/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import org.eclipse.jetty.http.HttpCookie;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

public class HttpCookieTest {
    @Test
    public void testDefaultSameSite() {
        TestServletContext context = new TestServletContext();
        Assertions.assertNull((Object)HttpCookie.getSameSiteDefault((ServletContext)context));
        context.setAttribute("org.eclipse.jetty.cookie.sameSiteDefault", HttpCookie.SameSite.LAX);
        Assertions.assertEquals((Object)HttpCookie.SameSite.LAX, (Object)HttpCookie.getSameSiteDefault((ServletContext)context));
        context.setAttribute("org.eclipse.jetty.cookie.sameSiteDefault", "NONE");
        Assertions.assertEquals((Object)HttpCookie.SameSite.NONE, (Object)HttpCookie.getSameSiteDefault((ServletContext)context));
        context.setAttribute("org.eclipse.jetty.cookie.sameSiteDefault", "sTrIcT");
        Assertions.assertEquals((Object)HttpCookie.SameSite.STRICT, (Object)HttpCookie.getSameSiteDefault((ServletContext)context));
        context.setAttribute("org.eclipse.jetty.cookie.sameSiteDefault", "fooBAR");
        Assertions.assertThrows(IllegalStateException.class, () -> HttpCookie.getSameSiteDefault((ServletContext)context));
    }

    @Test
    public void testConstructFromSetCookie() {
        HttpCookie cookie = new HttpCookie("everything=value; Path=path; Domain=domain; Expires=Thu, 01-Jan-1970 00:00:00 GMT; Max-Age=0; Secure; HttpOnly");
    }

    @Test
    public void testSetRFC2965Cookie() throws Exception {
        HttpCookie httpCookie = new HttpCookie("null", null, null, null, -1L, false, false, null, -1);
        Assertions.assertEquals((Object)"null=", (Object)httpCookie.getRFC2965SetCookie());
        httpCookie = new HttpCookie("minimal", "value", null, null, -1L, false, false, null, -1);
        Assertions.assertEquals((Object)"minimal=value", (Object)httpCookie.getRFC2965SetCookie());
        httpCookie = new HttpCookie("everything", "something", "domain", "path", 0L, true, true, "noncomment", 0);
        Assertions.assertEquals((Object)"everything=something;Version=1;Path=path;Domain=domain;Expires=Thu, 01-Jan-1970 00:00:00 GMT;Max-Age=0;Secure;HttpOnly;Comment=noncomment", (Object)httpCookie.getRFC2965SetCookie());
        httpCookie = new HttpCookie("everything", "value", "domain", "path", 0L, true, true, "comment", 0);
        Assertions.assertEquals((Object)"everything=value;Version=1;Path=path;Domain=domain;Expires=Thu, 01-Jan-1970 00:00:00 GMT;Max-Age=0;Secure;HttpOnly;Comment=comment", (Object)httpCookie.getRFC2965SetCookie());
        httpCookie = new HttpCookie("ev erything", "va lue", "do main", "pa th", 1L, true, true, "co mment", 1);
        String setCookie = httpCookie.getRFC2965SetCookie();
        MatcherAssert.assertThat((Object)setCookie, (Matcher)Matchers.startsWith((String)"\"ev erything\"=\"va lue\";Version=1;Path=\"pa th\";Domain=\"do main\";Expires="));
        MatcherAssert.assertThat((Object)setCookie, (Matcher)Matchers.endsWith((String)" GMT;Max-Age=1;Secure;HttpOnly;Comment=\"co mment\""));
        httpCookie = new HttpCookie("name", "value", null, null, -1L, false, false, null, 0);
        setCookie = httpCookie.getRFC2965SetCookie();
        Assertions.assertEquals((int)-1, (int)setCookie.indexOf("Version="));
        httpCookie = new HttpCookie("name", "v a l u e", null, null, -1L, false, false, null, 0);
        setCookie = httpCookie.getRFC2965SetCookie();
        httpCookie = new HttpCookie("json", "{\"services\":[\"cwa\",  \"aa\"]}", null, null, -1L, false, false, null, -1);
        Assertions.assertEquals((Object)"json=\"{\\\"services\\\":[\\\"cwa\\\",  \\\"aa\\\"]}\"", (Object)httpCookie.getRFC2965SetCookie());
        httpCookie = new HttpCookie("name", "value%=", null, null, -1L, false, false, null, 0);
        setCookie = httpCookie.getRFC2965SetCookie();
        Assertions.assertEquals((Object)"name=value%=", (Object)setCookie);
    }

    @Test
    public void testSetRFC6265Cookie() throws Exception {
        HttpCookie httpCookie = new HttpCookie("null", null, null, null, -1L, false, false, null, -1);
        Assertions.assertEquals((Object)"null=", (Object)httpCookie.getRFC6265SetCookie());
        httpCookie = new HttpCookie("minimal", "value", null, null, -1L, false, false, null, -1);
        Assertions.assertEquals((Object)"minimal=value", (Object)httpCookie.getRFC6265SetCookie());
        httpCookie = new HttpCookie("everything", "something", "domain", "path", 0L, true, true, null, -1);
        Assertions.assertEquals((Object)"everything=something; Path=path; Domain=domain; Expires=Thu, 01-Jan-1970 00:00:00 GMT; Max-Age=0; Secure; HttpOnly", (Object)httpCookie.getRFC6265SetCookie());
        httpCookie = new HttpCookie("everything", "value", "domain", "path", 0L, true, true, null, -1);
        Assertions.assertEquals((Object)"everything=value; Path=path; Domain=domain; Expires=Thu, 01-Jan-1970 00:00:00 GMT; Max-Age=0; Secure; HttpOnly", (Object)httpCookie.getRFC6265SetCookie());
        httpCookie = new HttpCookie("everything", "value", "domain", "path", 0L, true, true, null, -1, HttpCookie.SameSite.NONE);
        Assertions.assertEquals((Object)"everything=value; Path=path; Domain=domain; Expires=Thu, 01-Jan-1970 00:00:00 GMT; Max-Age=0; Secure; HttpOnly; SameSite=None", (Object)httpCookie.getRFC6265SetCookie());
        httpCookie = new HttpCookie("everything", "value", "domain", "path", 0L, true, true, null, -1, HttpCookie.SameSite.LAX);
        Assertions.assertEquals((Object)"everything=value; Path=path; Domain=domain; Expires=Thu, 01-Jan-1970 00:00:00 GMT; Max-Age=0; Secure; HttpOnly; SameSite=Lax", (Object)httpCookie.getRFC6265SetCookie());
        httpCookie = new HttpCookie("everything", "value", "domain", "path", 0L, true, true, null, -1, HttpCookie.SameSite.STRICT);
        Assertions.assertEquals((Object)"everything=value; Path=path; Domain=domain; Expires=Thu, 01-Jan-1970 00:00:00 GMT; Max-Age=0; Secure; HttpOnly; SameSite=Strict", (Object)httpCookie.getRFC6265SetCookie());
    }

    public static Stream<String> rfc6265BadNameSource() {
        return Stream.of("\"name\"", "name\t", "na me", "name\u0082", "na\tme", "na;me", "{name}", "[name]", "\"");
    }

    @ParameterizedTest
    @MethodSource(value={"rfc6265BadNameSource"})
    public void testSetRFC6265CookieBadName(String badNameExample) {
        IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> {
            HttpCookie httpCookie = new HttpCookie(badNameExample, "value", null, "/", 1L, true, true, null, -1);
            httpCookie.getRFC6265SetCookie();
        });
        MatcherAssert.assertThat((String)"message", (Object)ex.getMessage(), (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"RFC6265"), (Matcher)Matchers.containsString((String)"RFC2616")));
    }

    public static Stream<String> rfc6265BadValueSource() {
        return Stream.of("va\tlue", "\t", "value\u0000", "val\u0082ue", "va lue", "va;lue", "\"value", "value\"", "val\\ue", "val\"ue", "\"");
    }

    @ParameterizedTest
    @MethodSource(value={"rfc6265BadValueSource"})
    public void testSetRFC6265CookieBadValue(String badValueExample) {
        IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> {
            HttpCookie httpCookie = new HttpCookie("name", badValueExample, null, "/", 1L, true, true, null, -1);
            httpCookie.getRFC6265SetCookie();
        });
        MatcherAssert.assertThat((String)"message", (Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"RFC6265"));
    }

    public static Stream<String> rfc6265GoodNameSource() {
        return Stream.of("name", "n.a.m.e", "na-me", "+name", "na*me", "na$me", "#name");
    }

    @ParameterizedTest
    @MethodSource(value={"rfc6265GoodNameSource"})
    public void testSetRFC6265CookieGoodName(String goodNameExample) {
        new HttpCookie(goodNameExample, "value", null, "/", 1L, true, true, null, -1);
    }

    public static Stream<String> rfc6265GoodValueSource() {
        String[] goodValueExamples = new String[]{"value", "", null, "val=ue", "val-ue", "val/ue", "v.a.l.u.e"};
        return Stream.of(goodValueExamples);
    }

    @ParameterizedTest
    @MethodSource(value={"rfc6265GoodValueSource"})
    public void testSetRFC6265CookieGoodValue(String goodValueExample) {
        new HttpCookie("name", goodValueExample, null, "/", 1L, true, true, null, -1);
    }

    @ParameterizedTest
    @ValueSource(strings={"__HTTP_ONLY__", "__HTTP_ONLY__comment", "comment__HTTP_ONLY__"})
    public void testIsHttpOnlyInCommentTrue(String comment) {
        Assertions.assertTrue((boolean)HttpCookie.isHttpOnlyInComment((String)comment), (String)("Comment \"" + comment + "\""));
    }

    @ParameterizedTest
    @ValueSource(strings={"comment", "", "__", "__HTTP__ONLY__", "__http_only__", "HTTP_ONLY", "__HTTP__comment__ONLY__"})
    public void testIsHttpOnlyInCommentFalse(String comment) {
        Assertions.assertFalse((boolean)HttpCookie.isHttpOnlyInComment((String)comment), (String)("Comment \"" + comment + "\""));
    }

    @ParameterizedTest
    @ValueSource(strings={"__SAME_SITE_NONE__", "__SAME_SITE_NONE____SAME_SITE_NONE__"})
    public void testGetSameSiteFromCommentNONE(String comment) {
        Assertions.assertEquals((Object)HttpCookie.getSameSiteFromComment((String)comment), (Object)HttpCookie.SameSite.NONE, (String)("Comment \"" + comment + "\""));
    }

    @ParameterizedTest
    @ValueSource(strings={"__SAME_SITE_LAX__", "__SAME_SITE_LAX____SAME_SITE_NONE__", "__SAME_SITE_NONE____SAME_SITE_LAX__", "__SAME_SITE_LAX____SAME_SITE_NONE__"})
    public void testGetSameSiteFromCommentLAX(String comment) {
        Assertions.assertEquals((Object)HttpCookie.getSameSiteFromComment((String)comment), (Object)HttpCookie.SameSite.LAX, (String)("Comment \"" + comment + "\""));
    }

    @ParameterizedTest
    @ValueSource(strings={"__SAME_SITE_STRICT__", "__SAME_SITE_NONE____SAME_SITE_STRICT____SAME_SITE_LAX__", "__SAME_SITE_STRICT____SAME_SITE_LAX____SAME_SITE_NONE__", "__SAME_SITE_STRICT____SAME_SITE_STRICT__"})
    public void testGetSameSiteFromCommentSTRICT(String comment) {
        Assertions.assertEquals((Object)HttpCookie.getSameSiteFromComment((String)comment), (Object)HttpCookie.SameSite.STRICT, (String)("Comment \"" + comment + "\""));
    }

    @ParameterizedTest
    @ValueSource(strings={"__HTTP_ONLY__", "comment", "SameSite=None", "SameSite=Lax", "SameSite=Strict", "SAME_SITE_NONE", "SAME_SITE_LAX", "SAME_SITE_STRICT"})
    public void testGetSameSiteFromCommentUndefined(String comment) {
        Assertions.assertNull((Object)HttpCookie.getSameSiteFromComment((String)comment), (String)("Comment \"" + comment + "\""));
    }

    public static Stream<Arguments> getCommentWithoutAttributesSource() {
        return Stream.of(Arguments.of((Object[])new Object[]{"__SAME_SITE_LAX__", null}), Arguments.of((Object[])new Object[]{"comment", "comment"}), Arguments.of((Object[])new Object[]{"comment__SAME_SITE_NONE__", "comment"}), Arguments.of((Object[])new Object[]{"comment__HTTP_ONLY____SAME_SITE_NONE__", "comment"}), Arguments.of((Object[])new Object[]{"__SAME_SITE_NONE__comment", "comment"}), Arguments.of((Object[])new Object[]{"__HTTP_ONLY____SAME_SITE_NONE__comment", "comment"}), Arguments.of((Object[])new Object[]{"__SAME_SITE_NONE__comment__HTTP_ONLY__", "comment"}), Arguments.of((Object[])new Object[]{"__HTTP_ONLY__comment__SAME_SITE_NONE__", "comment"}));
    }

    @ParameterizedTest
    @MethodSource(value={"getCommentWithoutAttributesSource"})
    public void testGetCommentWithoutAttributes(String rawComment, String expectedComment) {
        String actualComment = HttpCookie.getCommentWithoutAttributes((String)rawComment);
        if (expectedComment == null) {
            Assertions.assertNull((Object)actualComment);
        } else {
            Assertions.assertEquals((Object)actualComment, (Object)expectedComment);
        }
    }

    @Test
    public void testGetCommentWithAttributes() {
        MatcherAssert.assertThat((Object)HttpCookie.getCommentWithAttributes(null, (boolean)false, null), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)HttpCookie.getCommentWithAttributes((String)"", (boolean)false, null), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)HttpCookie.getCommentWithAttributes((String)"hello", (boolean)false, null), (Matcher)Matchers.is((Object)"hello"));
        MatcherAssert.assertThat((Object)HttpCookie.getCommentWithAttributes(null, (boolean)true, (HttpCookie.SameSite)HttpCookie.SameSite.STRICT), (Matcher)Matchers.is((Object)"__HTTP_ONLY____SAME_SITE_STRICT__"));
        MatcherAssert.assertThat((Object)HttpCookie.getCommentWithAttributes((String)"", (boolean)true, (HttpCookie.SameSite)HttpCookie.SameSite.NONE), (Matcher)Matchers.is((Object)"__HTTP_ONLY____SAME_SITE_NONE__"));
        MatcherAssert.assertThat((Object)HttpCookie.getCommentWithAttributes((String)"hello", (boolean)true, (HttpCookie.SameSite)HttpCookie.SameSite.LAX), (Matcher)Matchers.is((Object)"hello__HTTP_ONLY____SAME_SITE_LAX__"));
        MatcherAssert.assertThat((Object)HttpCookie.getCommentWithAttributes((String)"__HTTP_ONLY____SAME_SITE_LAX__", (boolean)false, null), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)HttpCookie.getCommentWithAttributes((String)"__HTTP_ONLY____SAME_SITE_LAX__", (boolean)true, (HttpCookie.SameSite)HttpCookie.SameSite.NONE), (Matcher)Matchers.is((Object)"__HTTP_ONLY____SAME_SITE_NONE__"));
        MatcherAssert.assertThat((Object)HttpCookie.getCommentWithAttributes((String)"__HTTP_ONLY____SAME_SITE_LAX__hello", (boolean)true, (HttpCookie.SameSite)HttpCookie.SameSite.LAX), (Matcher)Matchers.is((Object)"hello__HTTP_ONLY____SAME_SITE_LAX__"));
    }

    public static class TestServletContext
    implements ServletContext {
        private Map<String, Object> _attributes = new HashMap<String, Object>();

        public String getContextPath() {
            return null;
        }

        public ServletContext getContext(String uripath) {
            return null;
        }

        public int getMajorVersion() {
            return 0;
        }

        public int getMinorVersion() {
            return 0;
        }

        public int getEffectiveMajorVersion() {
            return 0;
        }

        public int getEffectiveMinorVersion() {
            return 0;
        }

        public String getMimeType(String file) {
            return null;
        }

        public Set<String> getResourcePaths(String path) {
            return null;
        }

        public URL getResource(String path) throws MalformedURLException {
            return null;
        }

        public InputStream getResourceAsStream(String path) {
            return null;
        }

        public RequestDispatcher getRequestDispatcher(String path) {
            return null;
        }

        public RequestDispatcher getNamedDispatcher(String name) {
            return null;
        }

        public Servlet getServlet(String name) throws ServletException {
            return null;
        }

        public Enumeration<Servlet> getServlets() {
            return null;
        }

        public Enumeration<String> getServletNames() {
            return null;
        }

        public void log(String msg) {
        }

        public void log(Exception exception, String msg) {
        }

        public void log(String message, Throwable throwable) {
        }

        public String getRealPath(String path) {
            return null;
        }

        public String getServerInfo() {
            return null;
        }

        public String getInitParameter(String name) {
            return null;
        }

        public Enumeration<String> getInitParameterNames() {
            return null;
        }

        public boolean setInitParameter(String name, String value) {
            return false;
        }

        public Object getAttribute(String name) {
            return this._attributes.get(name);
        }

        public Enumeration<String> getAttributeNames() {
            return Collections.enumeration(this._attributes.keySet());
        }

        public void setAttribute(String name, Object object) {
            this._attributes.put(name, object);
        }

        public void removeAttribute(String name) {
            this._attributes.remove(name);
        }

        public String getServletContextName() {
            return null;
        }

        public ServletRegistration.Dynamic addServlet(String servletName, String className) {
            return null;
        }

        public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
            return null;
        }

        public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
            return null;
        }

        public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
            return null;
        }

        public ServletRegistration getServletRegistration(String servletName) {
            return null;
        }

        public Map<String, ? extends ServletRegistration> getServletRegistrations() {
            return null;
        }

        public FilterRegistration.Dynamic addFilter(String filterName, String className) {
            return null;
        }

        public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
            return null;
        }

        public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
            return null;
        }

        public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
            return null;
        }

        public FilterRegistration getFilterRegistration(String filterName) {
            return null;
        }

        public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
            return null;
        }

        public SessionCookieConfig getSessionCookieConfig() {
            return null;
        }

        public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        }

        public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
            return null;
        }

        public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
            return null;
        }

        public void addListener(String className) {
        }

        public <T extends EventListener> void addListener(T t) {
        }

        public void addListener(Class<? extends EventListener> listenerClass) {
        }

        public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
            return null;
        }

        public JspConfigDescriptor getJspConfigDescriptor() {
            return null;
        }

        public ClassLoader getClassLoader() {
            return null;
        }

        public void declareRoles(String ... roleNames) {
        }

        public String getVirtualServerName() {
            return null;
        }
    }
}

