/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.server;

import java.lang.reflect.Constructor;
import java.util.Collection;
import org.subethamail.smtp.AuthenticationHandler;
import org.subethamail.smtp.AuthenticationHandlerFactory;
import org.subethamail.smtp.MessageContext;
import org.subethamail.smtp.MessageHandler;
import org.subethamail.smtp.MessageHandlerFactory;
import org.subethamail.smtp.MessageListener;
import org.subethamail.smtp.auth.DummyAuthenticationHandler;
import org.subethamail.smtp.server.AbstractMessageHandler;
import org.subethamail.smtp.server.DefaultMessageHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageListenerAdapter
implements MessageHandlerFactory {
    private Collection<MessageListener> listeners;
    private AuthenticationHandlerFactory authenticationHandlerFactory;
    private AuthenticationHandler authHandler;
    private Class<? extends AbstractMessageHandler> messageHandlerImpl = DefaultMessageHandler.class;

    public MessageListenerAdapter(Collection<MessageListener> listeners) {
        this.listeners = listeners;
    }

    @Override
    public MessageHandler create(MessageContext ctx) {
        return this.create(ctx, this.messageHandlerImpl);
    }

    public void setMessageHandlerImpl(Class<? extends AbstractMessageHandler> impl) {
        this.messageHandlerImpl = impl;
    }

    private MessageHandler create(MessageContext ctx, Class<? extends AbstractMessageHandler> c) {
        try {
            Constructor<? extends AbstractMessageHandler> cstr = c.getConstructor(MessageContext.class, AuthenticationHandler.class);
            AbstractMessageHandler handler = cstr.newInstance(ctx, this.getAuthenticationHandler());
            handler.setListeners(this.listeners);
            return handler;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Class must be a child of AbstractMessageHandler class");
        }
    }

    public AuthenticationHandlerFactory getAuthenticationHandlerFactory() {
        return this.authenticationHandlerFactory;
    }

    public synchronized void setAuthenticationHandlerFactory(AuthenticationHandlerFactory authenticationHandlerFactory) {
        this.authHandler = null;
        this.authenticationHandlerFactory = authenticationHandlerFactory;
    }

    public synchronized AuthenticationHandler getAuthenticationHandler() {
        if (this.authHandler != null) {
            return this.authHandler;
        }
        this.authHandler = this.getAuthenticationHandlerFactory() != null ? this.getAuthenticationHandlerFactory().create() : new DummyAuthenticationHandler();
        return this.authHandler;
    }
}

