/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.httpclient;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.Socks5ProxyHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.codec.MockServerBinaryClientCodec;
import org.mockserver.codec.MockServerHttpClientCodec;
import org.mockserver.httpclient.HttpClientConnectionErrorHandler;
import org.mockserver.httpclient.HttpClientHandler;
import org.mockserver.httpclient.NettyHttpClient;
import org.mockserver.logging.LoggingHandler;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.proxyconfiguration.ProxyConfiguration;
import org.mockserver.socket.tls.NettySslContextFactory;
import org.slf4j.event.Level;

@ChannelHandler.Sharable
public class HttpClientInitializer
extends ChannelInitializer<SocketChannel> {
    private final MockServerLogger mockServerLogger;
    private final boolean forwardProxyClient;
    private final boolean isHttp;
    private final HttpClientConnectionErrorHandler httpClientConnectionHandler;
    private final HttpClientHandler httpClientHandler;
    private final Map<ProxyConfiguration.Type, ProxyConfiguration> proxyConfigurations;
    private final NettySslContextFactory nettySslContextFactory;

    HttpClientInitializer(Map<ProxyConfiguration.Type, ProxyConfiguration> proxyConfigurations, MockServerLogger mockServerLogger, boolean forwardProxyClient, NettySslContextFactory nettySslContextFactory, boolean isHttp) {
        this.proxyConfigurations = proxyConfigurations;
        this.mockServerLogger = mockServerLogger;
        this.forwardProxyClient = forwardProxyClient;
        this.isHttp = isHttp;
        this.httpClientHandler = new HttpClientHandler();
        this.httpClientConnectionHandler = new HttpClientConnectionErrorHandler();
        this.nettySslContextFactory = nettySslContextFactory;
    }

    public void initChannel(SocketChannel channel) {
        boolean secure;
        ChannelPipeline pipeline = channel.pipeline();
        boolean bl = secure = channel.attr(NettyHttpClient.SECURE) != null && channel.attr(NettyHttpClient.SECURE).get() != null && (Boolean)channel.attr(NettyHttpClient.SECURE).get() != false;
        if (this.proxyConfigurations != null) {
            ProxyConfiguration proxyConfiguration;
            if (secure && this.proxyConfigurations.containsKey((Object)ProxyConfiguration.Type.HTTPS)) {
                proxyConfiguration = this.proxyConfigurations.get((Object)ProxyConfiguration.Type.HTTPS);
                if (StringUtils.isNotBlank((CharSequence)proxyConfiguration.getUsername()) && StringUtils.isNotBlank((CharSequence)proxyConfiguration.getPassword())) {
                    pipeline.addLast(new ChannelHandler[]{new HttpProxyHandler((SocketAddress)proxyConfiguration.getProxyAddress(), proxyConfiguration.getUsername(), proxyConfiguration.getPassword())});
                } else {
                    pipeline.addLast(new ChannelHandler[]{new HttpProxyHandler((SocketAddress)proxyConfiguration.getProxyAddress())});
                }
            } else if (this.proxyConfigurations.containsKey((Object)ProxyConfiguration.Type.SOCKS5)) {
                proxyConfiguration = this.proxyConfigurations.get((Object)ProxyConfiguration.Type.SOCKS5);
                if (StringUtils.isNotBlank((CharSequence)proxyConfiguration.getUsername()) && StringUtils.isNotBlank((CharSequence)proxyConfiguration.getPassword())) {
                    pipeline.addLast(new ChannelHandler[]{new Socks5ProxyHandler((SocketAddress)proxyConfiguration.getProxyAddress(), proxyConfiguration.getUsername(), proxyConfiguration.getPassword())});
                } else {
                    pipeline.addLast(new ChannelHandler[]{new Socks5ProxyHandler((SocketAddress)proxyConfiguration.getProxyAddress())});
                }
            }
        }
        pipeline.addLast(new ChannelHandler[]{this.httpClientConnectionHandler});
        if (secure) {
            InetSocketAddress remoteAddress = (InetSocketAddress)channel.attr(NettyHttpClient.REMOTE_SOCKET).get();
            pipeline.addLast(new ChannelHandler[]{this.nettySslContextFactory.createClientSslContext(this.forwardProxyClient).newHandler(channel.alloc(), remoteAddress.getHostName(), remoteAddress.getPort())});
        }
        if (MockServerLogger.isEnabled(Level.TRACE)) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler(HttpClientHandler.class.getName())});
        }
        if (this.isHttp) {
            pipeline.addLast(new ChannelHandler[]{new HttpClientCodec()});
            pipeline.addLast(new ChannelHandler[]{new HttpContentDecompressor()});
            pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE)});
            pipeline.addLast(new ChannelHandler[]{new MockServerHttpClientCodec(this.mockServerLogger, this.proxyConfigurations)});
        } else {
            pipeline.addLast(new ChannelHandler[]{new MockServerBinaryClientCodec()});
        }
        pipeline.addLast(new ChannelHandler[]{this.httpClientHandler});
    }
}

