/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Objects;
import org.mockserver.model.Body;
import org.mockserver.model.BodyWithContentType;
import org.mockserver.model.MediaType;

public class XmlBody
extends BodyWithContentType<String> {
    private int hashCode;
    public static final MediaType DEFAULT_XML_CONTENT_TYPE = MediaType.APPLICATION_XML_UTF_8;
    private final String xml;
    private final byte[] rawBytes;

    public XmlBody(String xml) {
        this(xml, DEFAULT_XML_CONTENT_TYPE);
    }

    public XmlBody(String xml, Charset charset) {
        this(xml, null, charset != null ? DEFAULT_XML_CONTENT_TYPE.withCharset(charset) : null);
    }

    public XmlBody(String xml, MediaType contentType) {
        this(xml, null, contentType);
    }

    public XmlBody(String xml, byte[] rawBytes, MediaType contentType) {
        super(Body.Type.XML, contentType);
        this.xml = xml;
        this.rawBytes = rawBytes == null && xml != null ? xml.getBytes(this.determineCharacterSet(contentType, MediaType.DEFAULT_TEXT_HTTP_CHARACTER_SET)) : rawBytes;
    }

    public static XmlBody xml(String xml) {
        return new XmlBody(xml);
    }

    public static XmlBody xml(String xml, Charset charset) {
        return new XmlBody(xml, charset);
    }

    public static XmlBody xml(String xml, MediaType contentType) {
        return new XmlBody(xml, contentType);
    }

    @Override
    public String getValue() {
        return this.xml;
    }

    @Override
    @JsonIgnore
    public byte[] getRawBytes() {
        return this.rawBytes;
    }

    @Override
    public String toString() {
        return this.xml;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        XmlBody xmlBody = (XmlBody)o;
        return Objects.equals(this.xml, xmlBody.xml) && Arrays.equals(this.rawBytes, xmlBody.rawBytes);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            int result = Objects.hash(super.hashCode(), this.xml);
            this.hashCode = 31 * result + Arrays.hashCode(this.rawBytes);
        }
        return this.hashCode;
    }
}

