#ifndef DOM_BINDINGNAMES_H_
#define DOM_BINDINGNAMES_H_

#include <stddef.h>
#include <stdint.h>
#include "mozilla/Attributes.h"

namespace mozilla::dom {

enum class BindingNamesOffset : uint16_t {
  ANGLE_instanced_arrays = 0,
  APZHitResultFlags = 23,
  AbortController = 41,
  AbortSignal = 57,
  AbstractRange = 69,
  AccessibleNode = 83,
  Addon = 98,
  AddonEvent = 104,
  AddonInstall = 115,
  AddonManager = 128,
  AddonManagerPermissions = 141,
  AnalyserNode = 165,
  Animation = 178,
  AnimationEffect = 188,
  AnimationEvent = 204,
  AnimationPlaybackEvent = 219,
  AnimationTimeline = 242,
  AnonymousContent = 260,
  Attr = 277,
  Audio = 282,
  AudioBuffer = 288,
  AudioBufferSourceNode = 300,
  AudioContext = 322,
  AudioData = 335,
  AudioDecoder = 345,
  AudioDestinationNode = 358,
  AudioEncoder = 379,
  AudioListener = 392,
  AudioNode = 406,
  AudioParam = 416,
  AudioParamMap = 427,
  AudioProcessingEvent = 441,
  AudioScheduledSourceNode = 462,
  AudioTrack = 487,
  AudioTrackList = 498,
  AudioWorklet = 513,
  AudioWorkletGlobalScope = 526,
  AudioWorkletNode = 550,
  AudioWorkletProcessor = 567,
  AuthenticatorAssertionResponse = 589,
  AuthenticatorAttestationResponse = 620,
  AuthenticatorResponse = 653,
  BarProp = 675,
  BaseAudioContext = 683,
  BatteryManager = 700,
  BeforeUnloadEvent = 715,
  BiquadFilterNode = 733,
  Blob = 750,
  BlobEvent = 755,
  BroadcastChannel = 765,
  BrowsingContext = 782,
  BrowsingContextGroup = 798,
  ByteLengthQueuingStrategy = 819,
  CDATASection = 845,
  CSS = 858,
  CSS2Properties = 862,
  CSSAnimation = 877,
  CSSConditionRule = 890,
  CSSContainerRule = 907,
  CSSCounterStyleRule = 924,
  CSSCustomPropertyRegisteredEvent = 944,
  CSSFontFaceRule = 977,
  CSSFontFeatureValuesRule = 993,
  CSSFontPaletteValuesRule = 1018,
  CSSGroupingRule = 1043,
  CSSImportRule = 1059,
  CSSKeyframeRule = 1073,
  CSSKeyframesRule = 1089,
  CSSLayerBlockRule = 1106,
  CSSLayerStatementRule = 1124,
  CSSMarginRule = 1146,
  CSSMediaRule = 1160,
  CSSMozDocumentRule = 1173,
  CSSNamespaceRule = 1192,
  CSSPageRule = 1209,
  CSSPropertyRule = 1221,
  CSSPseudoElement = 1237,
  CSSRule = 1254,
  CSSRuleList = 1262,
  CSSScopeRule = 1274,
  CSSStartingStyleRule = 1287,
  CSSStyleDeclaration = 1308,
  CSSStyleRule = 1328,
  CSSStyleSheet = 1341,
  CSSSupportsRule = 1355,
  CSSTransition = 1371,
  Cache = 1385,
  CacheStorage = 1391,
  CallbackDebuggerNotification = 1404,
  CanonicalBrowsingContext = 1433,
  CanvasCaptureMediaStream = 1458,
  CanvasGradient = 1483,
  CanvasPattern = 1498,
  CanvasRenderingContext2D = 1512,
  CaretPosition = 1537,
  CaretStateChangedEvent = 1551,
  ChannelMergerNode = 1574,
  ChannelSplitterNode = 1592,
  ChannelWrapper = 1612,
  CharacterData = 1627,
  CheckerboardReportService = 1641,
  ChildProcessMessageManager = 1667,
  ChildSHistory = 1694,
  ChromeMessageBroadcaster = 1708,
  ChromeMessageSender = 1733,
  ChromeNodeList = 1753,
  ChromeUtils = 1768,
  ChromeWorker = 1780,
  Client = 1793,
  Clients = 1800,
  Clipboard = 1808,
  ClipboardEvent = 1818,
  ClipboardItem = 1833,
  ClonedErrorHolder = 1847,
  CloseEvent = 1865,
  CommandEvent = 1876,
  Comment = 1889,
  CompositionEvent = 1897,
  CompressionStream = 1914,
  ConsoleInstance = 1932,
  ConstantSourceNode = 1948,
  ContentFrameMessageManager = 1967,
  ContentProcessMessageManager = 1994,
  ContentVisibilityAutoStateChangeEvent = 2023,
  ConvolverNode = 2061,
  CountQueuingStrategy = 2075,
  CreateOfferRequest = 2096,
  Credential = 2115,
  CredentialsContainer = 2126,
  Crypto = 2147,
  CryptoKey = 2154,
  CustomElementRegistry = 2164,
  CustomEvent = 2186,
  CustomStateSet = 2198,
  DOMException = 2213,
  DOMImplementation = 2226,
  DOMLocalization = 2244,
  DOMMatrix = 2260,
  DOMMatrixReadOnly = 2270,
  DOMParser = 2288,
  DOMPoint = 2298,
  DOMPointReadOnly = 2307,
  DOMQuad = 2324,
  DOMRect = 2332,
  DOMRectList = 2340,
  DOMRectReadOnly = 2352,
  DOMStringList = 2368,
  DOMStringMap = 2382,
  DOMTokenList = 2395,
  DataTransfer = 2408,
  DataTransferItem = 2421,
  DataTransferItemList = 2438,
  DebuggerNotification = 2459,
  DebuggerNotificationObserver = 2480,
  DecompressionStream = 2509,
  DedicatedWorkerGlobalScope = 2529,
  DelayNode = 2556,
  DeprecationReportBody = 2566,
  DeviceAcceleration = 2588,
  DeviceLightEvent = 2607,
  DeviceMotionEvent = 2624,
  DeviceOrientationEvent = 2642,
  DeviceRotationRate = 2665,
  Directory = 2684,
  Document = 2694,
  DocumentFragment = 2703,
  DocumentL10n = 2720,
  DocumentTimeline = 2733,
  DocumentType = 2750,
  DominatorTree = 2763,
  DragEvent = 2777,
  DynamicsCompressorNode = 2787,
  EXT_blend_minmax = 2810,
  EXT_color_buffer_float = 2827,
  EXT_color_buffer_half_float = 2850,
  EXT_disjoint_timer_query = 2878,
  EXT_float_blend = 2903,
  EXT_frag_depth = 2919,
  EXT_sRGB = 2934,
  EXT_shader_texture_lod = 2943,
  EXT_texture_compression_bptc = 2966,
  EXT_texture_compression_rgtc = 2995,
  EXT_texture_filter_anisotropic = 3024,
  EXT_texture_norm16 = 3055,
  Element = 3074,
  ElementInternals = 3082,
  EncodedAudioChunk = 3099,
  EncodedVideoChunk = 3117,
  ErrorEvent = 3135,
  Event = 3146,
  EventCallbackDebuggerNotification = 3152,
  EventCounts = 3186,
  EventSource = 3198,
  EventTarget = 3210,
  Exception = 3222,
  ExtendableEvent = 3232,
  ExtendableMessageEvent = 3248,
  ExtensionAlarms = 3271,
  ExtensionBrowser = 3287,
  ExtensionBrowserSettings = 3304,
  ExtensionBrowserSettingsColorManagement = 3329,
  ExtensionDns = 3369,
  ExtensionEventManager = 3382,
  ExtensionMockAPI = 3404,
  ExtensionPort = 3421,
  ExtensionProxy = 3435,
  ExtensionRuntime = 3450,
  ExtensionScripting = 3467,
  ExtensionSetting = 3486,
  ExtensionTest = 3503,
  External = 3517,
  FeaturePolicy = 3526,
  FeaturePolicyViolationReportBody = 3540,
  FetchEvent = 3573,
  FetchObserver = 3584,
  File = 3598,
  FileList = 3603,
  FileReader = 3612,
  FileReaderSync = 3623,
  FileSystem = 3638,
  FileSystemDirectoryEntry = 3649,
  FileSystemDirectoryHandle = 3674,
  FileSystemDirectoryHandle_AsyncIterator = 3700,
  FileSystemDirectoryIterator = 3740,
  FileSystemDirectoryReader = 3768,
  FileSystemEntry = 3794,
  FileSystemFileEntry = 3810,
  FileSystemFileHandle = 3830,
  FileSystemHandle = 3851,
  FileSystemSyncAccessHandle = 3868,
  FileSystemWritableFileStream = 3895,
  Flex = 3924,
  FlexItemValues = 3929,
  FlexLineValues = 3944,
  FluentBundle = 3959,
  FluentBundleAsyncIterator = 3972,
  FluentBundleIterator = 3998,
  FluentPattern = 4019,
  FluentResource = 4033,
  FocusEvent = 4048,
  FontFace = 4059,
  FontFaceSet = 4068,
  FontFaceSetIterator = 4080,
  FontFaceSetLoadEvent = 4100,
  FormData = 4121,
  FormData_Iterator = 4130,
  FormDataEvent = 4148,
  FragmentDirective = 4162,
  FrameCrashedEvent = 4180,
  FrameLoader = 4198,
  GPU = 4210,
  GPUAdapter = 4214,
  GPUAdapterInfo = 4225,
  GPUBindGroup = 4240,
  GPUBindGroupLayout = 4253,
  GPUBuffer = 4272,
  GPUBufferUsage = 4282,
  GPUCanvasContext = 4297,
  GPUColorWrite = 4314,
  GPUCommandBuffer = 4328,
  GPUCommandEncoder = 4345,
  GPUCompilationInfo = 4363,
  GPUCompilationMessage = 4382,
  GPUComputePassEncoder = 4404,
  GPUComputePipeline = 4426,
  GPUDevice = 4445,
  GPUDeviceLostInfo = 4455,
  GPUError = 4473,
  GPUInternalError = 4482,
  GPUMapMode = 4499,
  GPUOutOfMemoryError = 4510,
  GPUPipelineLayout = 4530,
  GPUQuerySet = 4548,
  GPUQueue = 4560,
  GPURenderBundle = 4569,
  GPURenderBundleEncoder = 4585,
  GPURenderPassEncoder = 4608,
  GPURenderPipeline = 4629,
  GPUSampler = 4647,
  GPUShaderModule = 4658,
  GPUShaderStage = 4674,
  GPUSupportedFeatures = 4689,
  GPUSupportedLimits = 4710,
  GPUTexture = 4729,
  GPUTextureUsage = 4740,
  GPUTextureView = 4756,
  GPUUncapturedErrorEvent = 4771,
  GPUValidationError = 4795,
  GainNode = 4814,
  Gamepad = 4823,
  GamepadAxisMoveEvent = 4831,
  GamepadButton = 4852,
  GamepadButtonEvent = 4866,
  GamepadEvent = 4885,
  GamepadHapticActuator = 4898,
  GamepadLightIndicator = 4920,
  GamepadPose = 4942,
  GamepadServiceTest = 4954,
  GamepadTouch = 4973,
  Geolocation = 4986,
  GeolocationCoordinates = 4998,
  GeolocationPosition = 5021,
  GeolocationPositionError = 5041,
  GetUserMediaRequest = 5066,
  GleanBoolean = 5086,
  GleanCategory = 5099,
  GleanCounter = 5113,
  GleanCustomDistribution = 5126,
  GleanDatetime = 5150,
  GleanDenominator = 5164,
  GleanEvent = 5181,
  GleanImpl = 5192,
  GleanLabeled = 5202,
  GleanMemoryDistribution = 5215,
  GleanMetric = 5239,
  GleanNumerator = 5251,
  GleanObject = 5266,
  GleanPingsImpl = 5278,
  GleanQuantity = 5293,
  GleanRate = 5307,
  GleanString = 5317,
  GleanStringList = 5329,
  GleanText = 5345,
  GleanTimespan = 5355,
  GleanTimingDistribution = 5369,
  GleanUrl = 5393,
  GleanUuid = 5402,
  Grid = 5412,
  GridArea = 5417,
  GridDimension = 5426,
  GridLine = 5440,
  GridLines = 5449,
  GridTrack = 5459,
  GridTracks = 5469,
  HTMLAllCollection = 5480,
  HTMLAnchorElement = 5498,
  HTMLAreaElement = 5516,
  HTMLAudioElement = 5532,
  HTMLBRElement = 5549,
  HTMLBaseElement = 5563,
  HTMLBodyElement = 5579,
  HTMLButtonElement = 5595,
  HTMLCanvasElement = 5613,
  HTMLCollection = 5631,
  HTMLDListElement = 5646,
  HTMLDataElement = 5663,
  HTMLDataListElement = 5679,
  HTMLDetailsElement = 5699,
  HTMLDialogElement = 5718,
  HTMLDirectoryElement = 5736,
  HTMLDivElement = 5757,
  HTMLDocument = 5772,
  HTMLElement = 5785,
  HTMLEmbedElement = 5797,
  HTMLFieldSetElement = 5814,
  HTMLFontElement = 5834,
  HTMLFormControlsCollection = 5850,
  HTMLFormElement = 5877,
  HTMLFrameElement = 5893,
  HTMLFrameSetElement = 5910,
  HTMLHRElement = 5930,
  HTMLHeadElement = 5944,
  HTMLHeadingElement = 5960,
  HTMLHtmlElement = 5979,
  HTMLIFrameElement = 5995,
  HTMLImageElement = 6013,
  HTMLInputElement = 6030,
  HTMLLIElement = 6047,
  HTMLLabelElement = 6061,
  HTMLLegendElement = 6078,
  HTMLLinkElement = 6096,
  HTMLMapElement = 6112,
  HTMLMarqueeElement = 6127,
  HTMLMediaElement = 6146,
  HTMLMenuElement = 6163,
  HTMLMetaElement = 6179,
  HTMLMeterElement = 6195,
  HTMLModElement = 6212,
  HTMLOListElement = 6227,
  HTMLObjectElement = 6244,
  HTMLOptGroupElement = 6262,
  HTMLOptionElement = 6282,
  HTMLOptionsCollection = 6300,
  HTMLOutputElement = 6322,
  HTMLParagraphElement = 6340,
  HTMLParamElement = 6361,
  HTMLPictureElement = 6378,
  HTMLPreElement = 6397,
  HTMLProgressElement = 6412,
  HTMLQuoteElement = 6432,
  HTMLScriptElement = 6449,
  HTMLSelectElement = 6467,
  HTMLSlotElement = 6485,
  HTMLSourceElement = 6501,
  HTMLSpanElement = 6519,
  HTMLStyleElement = 6535,
  HTMLTableCaptionElement = 6552,
  HTMLTableCellElement = 6576,
  HTMLTableColElement = 6597,
  HTMLTableElement = 6617,
  HTMLTableRowElement = 6634,
  HTMLTableSectionElement = 6654,
  HTMLTemplateElement = 6678,
  HTMLTextAreaElement = 6698,
  HTMLTimeElement = 6718,
  HTMLTitleElement = 6734,
  HTMLTrackElement = 6751,
  HTMLUListElement = 6768,
  HTMLUnknownElement = 6785,
  HTMLVideoElement = 6804,
  HashChangeEvent = 6821,
  Headers = 6837,
  Headers_Iterator = 6845,
  HeapSnapshot = 6862,
  Highlight = 6875,
  HighlightRegistry = 6885,
  History = 6903,
  IDBCursor = 6911,
  IDBCursorWithValue = 6921,
  IDBDatabase = 6940,
  IDBFactory = 6952,
  IDBIndex = 6963,
  IDBKeyRange = 6972,
  IDBObjectStore = 6984,
  IDBOpenDBRequest = 6999,
  IDBRequest = 7016,
  IDBTransaction = 7027,
  IDBVersionChangeEvent = 7042,
  IIRFilterNode = 7064,
  IOUtils = 7078,
  IdentityCredential = 7086,
  IdleDeadline = 7105,
  Image = 7118,
  ImageBitmap = 7124,
  ImageBitmapRenderingContext = 7136,
  ImageCapture = 7164,
  ImageCaptureError = 7177,
  ImageCaptureErrorEvent = 7195,
  ImageData = 7218,
  ImageDocument = 7228,
  InputEvent = 7242,
  InspectorCSSParser = 7253,
  InspectorFontFace = 7272,
  InspectorUtils = 7290,
  InstallTriggerImpl = 7305,
  IntersectionObserver = 7324,
  IntersectionObserverEntry = 7345,
  IntlUtils = 7371,
  InvokeEvent = 7381,
  JSProcessActorChild = 7393,
  JSProcessActorParent = 7413,
  JSWindowActorChild = 7434,
  JSWindowActorParent = 7453,
  KeyEvent = 7473,
  KeyboardEvent = 7482,
  KeyframeEffect = 7496,
  L10nFileSource = 7511,
  L10nOverlays = 7526,
  L10nRegistry = 7539,
  LargestContentfulPaint = 7552,
  LegacyMozTCPSocket = 7575,
  Localization = 7594,
  Location = 7607,
  Lock = 7616,
  LockManager = 7621,
  MIDIAccess = 7633,
  MIDIConnectionEvent = 7644,
  MIDIInput = 7664,
  MIDIInputMap = 7674,
  MIDIMessageEvent = 7687,
  MIDIOutput = 7704,
  MIDIOutputMap = 7715,
  MIDIPort = 7729,
  MOZ_debug = 7738,
  MatchGlob = 7748,
  MatchPattern = 7758,
  MatchPatternSet = 7771,
  MathMLElement = 7787,
  MediaCapabilities = 7801,
  MediaCapabilitiesInfo = 7819,
  MediaControlService = 7841,
  MediaController = 7861,
  MediaDeviceInfo = 7877,
  MediaDevices = 7893,
  MediaElementAudioSourceNode = 7906,
  MediaEncryptedEvent = 7934,
  MediaError = 7954,
  MediaKeyError = 7965,
  MediaKeyMessageEvent = 7979,
  MediaKeySession = 8000,
  MediaKeyStatusMap = 8016,
  MediaKeyStatusMap_Iterator = 8034,
  MediaKeySystemAccess = 8061,
  MediaKeys = 8082,
  MediaList = 8092,
  MediaMetadata = 8102,
  MediaQueryList = 8116,
  MediaQueryListEvent = 8131,
  MediaRecorder = 8151,
  MediaRecorderErrorEvent = 8165,
  MediaSession = 8189,
  MediaSource = 8202,
  MediaStream = 8214,
  MediaStreamAudioDestinationNode = 8226,
  MediaStreamAudioSourceNode = 8258,
  MediaStreamError = 8285,
  MediaStreamEvent = 8302,
  MediaStreamTrack = 8319,
  MediaStreamTrackAudioSourceNode = 8336,
  MediaStreamTrackEvent = 8368,
  MerchantValidationEvent = 8390,
  MessageBroadcaster = 8414,
  MessageChannel = 8433,
  MessageEvent = 8448,
  MessageListenerManager = 8461,
  MessagePort = 8484,
  MessageSender = 8496,
  MimeType = 8510,
  MimeTypeArray = 8519,
  MouseEvent = 8533,
  MouseScrollEvent = 8544,
  MozCanvasPrintState = 8561,
  MozDocumentMatcher = 8581,
  MozDocumentObserver = 8600,
  MozQueryInterface = 8620,
  MozSharedMap = 8638,
  MozSharedMap_Iterator = 8651,
  MozSharedMapChangeEvent = 8673,
  MozStorageAsyncStatementParams = 8697,
  MozStorageStatementParams = 8728,
  MozStorageStatementRow = 8754,
  MozWritableSharedMap = 8777,
  MutationEvent = 8798,
  MutationObserver = 8812,
  MutationRecord = 8829,
  NamedNodeMap = 8844,
  NavigationPreloadManager = 8857,
  Navigator = 8882,
  NetworkInformation = 8892,
  Node = 8911,
  NodeFilter = 8916,
  NodeIterator = 8927,
  NodeList = 8940,
  Notification = 8949,
  NotificationEvent = 8962,
  NotifyPaintEvent = 8980,
  OES_draw_buffers_indexed = 8997,
  OES_element_index_uint = 9022,
  OES_fbo_render_mipmap = 9045,
  OES_standard_derivatives = 9067,
  OES_texture_float = 9092,
  OES_texture_float_linear = 9110,
  OES_texture_half_float = 9135,
  OES_texture_half_float_linear = 9158,
  OES_vertex_array_object = 9188,
  OVR_multiview2 = 9212,
  OfflineAudioCompletionEvent = 9227,
  OfflineAudioContext = 9255,
  OffscreenCanvas = 9275,
  OffscreenCanvasRenderingContext2D = 9291,
  Option = 9325,
  OscillatorNode = 9332,
  PageTransitionEvent = 9347,
  PaintRequest = 9367,
  PaintRequestList = 9380,
  PaintWorkletGlobalScope = 9397,
  PannerNode = 9421,
  ParentProcessMessageManager = 9432,
  Path2D = 9460,
  PathUtils = 9467,
  PaymentAddress = 9477,
  PaymentMethodChangeEvent = 9492,
  PaymentRequest = 9517,
  PaymentRequestUpdateEvent = 9532,
  PaymentResponse = 9558,
  PeerConnectionImpl = 9574,
  PeerConnectionObserver = 9593,
  Performance = 9616,
  PerformanceEntry = 9628,
  PerformanceEntryEvent = 9645,
  PerformanceEventTiming = 9667,
  PerformanceMark = 9690,
  PerformanceMeasure = 9706,
  PerformanceNavigation = 9725,
  PerformanceNavigationTiming = 9747,
  PerformanceObserver = 9775,
  PerformanceObserverEntryList = 9795,
  PerformancePaintTiming = 9824,
  PerformanceResourceTiming = 9847,
  PerformanceServerTiming = 9873,
  PerformanceTiming = 9897,
  PeriodicWave = 9915,
  PermissionStatus = 9928,
  Permissions = 9945,
  PlacesBookmark = 9957,
  PlacesBookmarkAddition = 9972,
  PlacesBookmarkChanged = 9995,
  PlacesBookmarkGuid = 10017,
  PlacesBookmarkKeyword = 10036,
  PlacesBookmarkMoved = 10058,
  PlacesBookmarkRemoved = 10078,
  PlacesBookmarkTags = 10100,
  PlacesBookmarkTime = 10119,
  PlacesBookmarkTitle = 10138,
  PlacesBookmarkUrl = 10158,
  PlacesEvent = 10176,
  PlacesEventCounts = 10188,
  PlacesFavicon = 10206,
  PlacesHistoryCleared = 10220,
  PlacesObservers = 10241,
  PlacesPurgeCaches = 10257,
  PlacesRanking = 10275,
  PlacesVisit = 10289,
  PlacesVisitRemoved = 10301,
  PlacesVisitTitle = 10320,
  PlacesWeakCallbackWrapper = 10337,
  Plugin = 10363,
  PluginArray = 10370,
  PluginCrashedEvent = 10382,
  PointerEvent = 10401,
  PopStateEvent = 10414,
  PopupBlockedEvent = 10428,
  PopupPositionedEvent = 10446,
  PositionStateEvent = 10467,
  PrecompiledScript = 10486,
  PrivateAttribution = 10504,
  ProcessMessageManager = 10523,
  ProcessingInstruction = 10545,
  ProgressEvent = 10567,
  PromiseDebugging = 10581,
  PromiseNativeHandler = 10598,
  PromiseRejectionEvent = 10619,
  PublicKeyCredential = 10641,
  PushEvent = 10661,
  PushManager = 10671,
  PushManagerImpl = 10683,
  PushMessageData = 10699,
  PushSubscription = 10715,
  PushSubscriptionOptions = 10732,
  RTCCertificate = 10756,
  RTCDTMFSender = 10771,
  RTCDTMFToneChangeEvent = 10785,
  RTCDataChannel = 10808,
  RTCDataChannelEvent = 10823,
  RTCDtlsTransport = 10843,
  RTCEncodedAudioFrame = 10860,
  RTCEncodedVideoFrame = 10881,
  RTCIceCandidate = 10902,
  RTCIceTransport = 10918,
  RTCIdentityProviderRegistrar = 10934,
  RTCPeerConnection = 10963,
  RTCPeerConnectionIceEvent = 10981,
  RTCPeerConnectionStatic = 11007,
  RTCRtpReceiver = 11031,
  RTCRtpScriptTransform = 11046,
  RTCRtpScriptTransformer = 11068,
  RTCRtpSender = 11092,
  RTCRtpTransceiver = 11105,
  RTCSctpTransport = 11123,
  RTCSessionDescription = 11140,
  RTCStatsReport = 11162,
  RTCTrackEvent = 11177,
  RTCTransformEvent = 11191,
  RadioNodeList = 11209,
  Range = 11223,
  ReadableByteStreamController = 11229,
  ReadableStream = 11258,
  ReadableStream_AsyncIterator = 11273,
  ReadableStreamBYOBReader = 11302,
  ReadableStreamBYOBRequest = 11327,
  ReadableStreamDefaultController = 11353,
  ReadableStreamDefaultReader = 11385,
  Report = 11413,
  ReportBody = 11420,
  ReportingObserver = 11431,
  Request = 11449,
  ResizeObserver = 11457,
  ResizeObserverEntry = 11472,
  ResizeObserverSize = 11492,
  Response = 11511,
  SVGAElement = 11520,
  SVGAngle = 11532,
  SVGAnimateElement = 11541,
  SVGAnimateMotionElement = 11559,
  SVGAnimateTransformElement = 11583,
  SVGAnimatedAngle = 11610,
  SVGAnimatedBoolean = 11627,
  SVGAnimatedEnumeration = 11646,
  SVGAnimatedInteger = 11669,
  SVGAnimatedLength = 11688,
  SVGAnimatedLengthList = 11706,
  SVGAnimatedNumber = 11728,
  SVGAnimatedNumberList = 11746,
  SVGAnimatedPreserveAspectRatio = 11768,
  SVGAnimatedRect = 11799,
  SVGAnimatedString = 11815,
  SVGAnimatedTransformList = 11833,
  SVGAnimationElement = 11858,
  SVGCircleElement = 11878,
  SVGClipPathElement = 11895,
  SVGComponentTransferFunctionElement = 11914,
  SVGDefsElement = 11950,
  SVGDescElement = 11965,
  SVGElement = 11980,
  SVGEllipseElement = 11991,
  SVGFEBlendElement = 12009,
  SVGFEColorMatrixElement = 12027,
  SVGFEComponentTransferElement = 12051,
  SVGFECompositeElement = 12081,
  SVGFEConvolveMatrixElement = 12103,
  SVGFEDiffuseLightingElement = 12130,
  SVGFEDisplacementMapElement = 12158,
  SVGFEDistantLightElement = 12186,
  SVGFEDropShadowElement = 12211,
  SVGFEFloodElement = 12234,
  SVGFEFuncAElement = 12252,
  SVGFEFuncBElement = 12270,
  SVGFEFuncGElement = 12288,
  SVGFEFuncRElement = 12306,
  SVGFEGaussianBlurElement = 12324,
  SVGFEImageElement = 12349,
  SVGFEMergeElement = 12367,
  SVGFEMergeNodeElement = 12385,
  SVGFEMorphologyElement = 12407,
  SVGFEOffsetElement = 12430,
  SVGFEPointLightElement = 12449,
  SVGFESpecularLightingElement = 12472,
  SVGFESpotLightElement = 12501,
  SVGFETileElement = 12523,
  SVGFETurbulenceElement = 12540,
  SVGFilterElement = 12563,
  SVGForeignObjectElement = 12580,
  SVGGElement = 12604,
  SVGGeometryElement = 12616,
  SVGGradientElement = 12635,
  SVGGraphicsElement = 12654,
  SVGImageElement = 12673,
  SVGLength = 12689,
  SVGLengthList = 12699,
  SVGLineElement = 12713,
  SVGLinearGradientElement = 12728,
  SVGMPathElement = 12753,
  SVGMarkerElement = 12769,
  SVGMaskElement = 12786,
  SVGMatrix = 12801,
  SVGMetadataElement = 12811,
  SVGNumber = 12830,
  SVGNumberList = 12840,
  SVGPathElement = 12854,
  SVGPathSeg = 12869,
  SVGPathSegArcAbs = 12880,
  SVGPathSegArcRel = 12897,
  SVGPathSegClosePath = 12914,
  SVGPathSegCurvetoCubicAbs = 12934,
  SVGPathSegCurvetoCubicRel = 12960,
  SVGPathSegCurvetoCubicSmoothAbs = 12986,
  SVGPathSegCurvetoCubicSmoothRel = 13018,
  SVGPathSegCurvetoQuadraticAbs = 13050,
  SVGPathSegCurvetoQuadraticRel = 13080,
  SVGPathSegCurvetoQuadraticSmoothAbs = 13110,
  SVGPathSegCurvetoQuadraticSmoothRel = 13146,
  SVGPathSegLinetoAbs = 13182,
  SVGPathSegLinetoHorizontalAbs = 13202,
  SVGPathSegLinetoHorizontalRel = 13232,
  SVGPathSegLinetoRel = 13262,
  SVGPathSegLinetoVerticalAbs = 13282,
  SVGPathSegLinetoVerticalRel = 13310,
  SVGPathSegList = 13338,
  SVGPathSegMovetoAbs = 13353,
  SVGPathSegMovetoRel = 13373,
  SVGPatternElement = 13393,
  SVGPoint = 13411,
  SVGPointList = 13420,
  SVGPolygonElement = 13433,
  SVGPolylineElement = 13451,
  SVGPreserveAspectRatio = 13470,
  SVGRadialGradientElement = 13493,
  SVGRect = 13518,
  SVGRectElement = 13526,
  SVGSVGElement = 13541,
  SVGScriptElement = 13555,
  SVGSetElement = 13572,
  SVGStopElement = 13586,
  SVGStringList = 13601,
  SVGStyleElement = 13615,
  SVGSwitchElement = 13631,
  SVGSymbolElement = 13648,
  SVGTSpanElement = 13665,
  SVGTextContentElement = 13681,
  SVGTextElement = 13703,
  SVGTextPathElement = 13718,
  SVGTextPositioningElement = 13737,
  SVGTitleElement = 13763,
  SVGTransform = 13779,
  SVGTransformList = 13792,
  SVGUnitTypes = 13809,
  SVGUseElement = 13822,
  SVGViewElement = 13836,
  Sanitizer = 13851,
  Scheduler = 13861,
  Screen = 13871,
  ScreenLuminance = 13878,
  ScreenOrientation = 13894,
  ScriptProcessorNode = 13912,
  ScrollAreaEvent = 13932,
  ScrollViewChangeEvent = 13948,
  SecurityPolicyViolationEvent = 13970,
  Selection = 13999,
  ServiceWorker = 14009,
  ServiceWorkerContainer = 14023,
  ServiceWorkerGlobalScope = 14046,
  ServiceWorkerRegistration = 14071,
  SessionStoreFormData = 14097,
  SessionStoreScrollData = 14118,
  SessionStoreUtils = 14141,
  ShadowRealmGlobalScope = 14159,
  ShadowRoot = 14182,
  SharedWorker = 14193,
  SharedWorkerGlobalScope = 14206,
  SimpleGestureEvent = 14230,
  SourceBuffer = 14249,
  SourceBufferList = 14262,
  SpeechGrammar = 14279,
  SpeechGrammarList = 14293,
  SpeechRecognition = 14311,
  SpeechRecognitionAlternative = 14329,
  SpeechRecognitionError = 14358,
  SpeechRecognitionEvent = 14381,
  SpeechRecognitionResult = 14404,
  SpeechRecognitionResultList = 14428,
  SpeechSynthesis = 14456,
  SpeechSynthesisErrorEvent = 14472,
  SpeechSynthesisEvent = 14498,
  SpeechSynthesisUtterance = 14519,
  SpeechSynthesisVoice = 14544,
  StaticRange = 14565,
  StereoPannerNode = 14577,
  Storage = 14594,
  StorageEvent = 14602,
  StorageManager = 14615,
  StreamFilter = 14630,
  StreamFilterDataEvent = 14643,
  StructuredCloneHolder = 14665,
  StructuredCloneTester = 14687,
  StyleSheet = 14709,
  StyleSheetApplicableStateChangeEvent = 14720,
  StyleSheetList = 14757,
  StyleSheetRemovedEvent = 14772,
  SubmitEvent = 14795,
  SubtleCrypto = 14807,
  SyncMessageSender = 14820,
  SyncReadFile = 14838,
  TCPServerSocket = 14851,
  TCPServerSocketEvent = 14867,
  TCPSocket = 14888,
  TCPSocketErrorEvent = 14898,
  TCPSocketEvent = 14918,
  TaskController = 14933,
  TaskPriorityChangeEvent = 14948,
  TaskSignal = 14972,
  TelemetryStopwatch = 14983,
  TestUtils = 15002,
  TestingDeprecatedInterface = 15012,
  Text = 15039,
  TextClause = 15044,
  TextDecoder = 15055,
  TextDecoderStream = 15067,
  TextEncoder = 15085,
  TextEncoderStream = 15097,
  TextEvent = 15115,
  TextMetrics = 15125,
  TextTrack = 15137,
  TextTrackCue = 15147,
  TextTrackCueList = 15160,
  TextTrackList = 15177,
  TimeEvent = 15191,
  TimeRanges = 15201,
  ToggleEvent = 15212,
  Touch = 15224,
  TouchEvent = 15230,
  TouchList = 15241,
  TrackEvent = 15251,
  TransformStream = 15262,
  TransformStreamDefaultController = 15278,
  TransitionEvent = 15311,
  TreeColumn = 15327,
  TreeColumns = 15338,
  TreeContentView = 15350,
  TreeWalker = 15366,
  TrustedHTML = 15377,
  TrustedScript = 15389,
  TrustedScriptURL = 15403,
  TrustedTypePolicy = 15420,
  TrustedTypePolicyFactory = 15438,
  UDPMessageEvent = 15463,
  UDPSocket = 15479,
  UIEvent = 15489,
  URL = 15497,
  URLSearchParams = 15501,
  URLSearchParams_Iterator = 15517,
  UniFFIPointer = 15542,
  UniFFIScaffolding = 15556,
  UserActivation = 15574,
  UserInteraction = 15589,
  UserProximityEvent = 15605,
  VRDisplay = 15624,
  VRDisplayCapabilities = 15634,
  VRDisplayEvent = 15656,
  VREyeParameters = 15671,
  VRFieldOfView = 15687,
  VRFrameData = 15701,
  VRMockController = 15713,
  VRMockDisplay = 15730,
  VRPose = 15744,
  VRServiceTest = 15751,
  VRStageParameters = 15765,
  VTTCue = 15783,
  VTTRegion = 15790,
  ValidityState = 15800,
  VideoColorSpace = 15814,
  VideoDecoder = 15830,
  VideoEncoder = 15843,
  VideoFrame = 15856,
  VideoPlaybackQuality = 15867,
  VideoTrack = 15888,
  VideoTrackList = 15899,
  VisualViewport = 15914,
  WEBGL_color_buffer_float = 15929,
  WEBGL_compressed_texture_astc = 15954,
  WEBGL_compressed_texture_etc = 15984,
  WEBGL_compressed_texture_etc1 = 16013,
  WEBGL_compressed_texture_pvrtc = 16043,
  WEBGL_compressed_texture_s3tc = 16074,
  WEBGL_compressed_texture_s3tc_srgb = 16104,
  WEBGL_debug_renderer_info = 16139,
  WEBGL_debug_shaders = 16165,
  WEBGL_depth_texture = 16185,
  WEBGL_draw_buffers = 16205,
  WEBGL_explicit_present = 16224,
  WEBGL_lose_context = 16247,
  WEBGL_provoking_vertex = 16266,
  WakeLock = 16289,
  WakeLockSentinel = 16298,
  WaveShaperNode = 16315,
  WebExtensionContentScript = 16330,
  WebExtensionPolicy = 16356,
  WebGL2RenderingContext = 16375,
  WebGLActiveInfo = 16398,
  WebGLBuffer = 16414,
  WebGLContextEvent = 16426,
  WebGLFramebuffer = 16444,
  WebGLProgram = 16461,
  WebGLQuery = 16474,
  WebGLRenderbuffer = 16485,
  WebGLRenderingContext = 16503,
  WebGLSampler = 16525,
  WebGLShader = 16538,
  WebGLShaderPrecisionFormat = 16550,
  WebGLSync = 16577,
  WebGLTexture = 16587,
  WebGLTransformFeedback = 16600,
  WebGLUniformLocation = 16623,
  WebGLVertexArrayObject = 16644,
  WebKitCSSMatrix = 16667,
  WebSocket = 16683,
  WebTransport = 16693,
  WebTransportBidirectionalStream = 16706,
  WebTransportDatagramDuplexStream = 16738,
  WebTransportError = 16771,
  WebTransportReceiveStream = 16789,
  WebTransportSendStream = 16815,
  WebrtcGlobalInformation = 16838,
  WheelEvent = 16862,
  Window = 16873,
  WindowClient = 16880,
  WindowContext = 16893,
  WindowGlobalChild = 16907,
  WindowGlobalParent = 16925,
  WindowRoot = 16944,
  Worker = 16955,
  WorkerDebuggerGlobalScope = 16962,
  WorkerGlobalScope = 16988,
  WorkerLocation = 17006,
  WorkerNavigator = 17021,
  WorkerTestUtils = 17037,
  Worklet = 17053,
  WorkletGlobalScope = 17061,
  WritableStream = 17080,
  WritableStreamDefaultController = 17095,
  WritableStreamDefaultWriter = 17127,
  XMLDocument = 17155,
  XMLHttpRequest = 17167,
  XMLHttpRequestEventTarget = 17182,
  XMLHttpRequestUpload = 17208,
  XMLSerializer = 17229,
  XPathEvaluator = 17243,
  XPathExpression = 17258,
  XPathResult = 17274,
  XRBoundedReferenceSpace = 17286,
  XRFrame = 17310,
  XRInputSource = 17318,
  XRInputSourceArray = 17332,
  XRInputSourceEvent = 17351,
  XRInputSourcesChangeEvent = 17370,
  XRPose = 17396,
  XRReferenceSpace = 17403,
  XRReferenceSpaceEvent = 17420,
  XRRenderState = 17442,
  XRRigidTransform = 17456,
  XRSession = 17473,
  XRSessionEvent = 17483,
  XRSpace = 17498,
  XRSystem = 17506,
  XRView = 17515,
  XRViewerPose = 17522,
  XRViewport = 17535,
  XRWebGLLayer = 17546,
  XSLTProcessor = 17559,
  XULCommandEvent = 17573,
  XULElement = 17589,
  XULFrameElement = 17600,
  XULMenuElement = 17616,
  XULPopupElement = 17631,
  XULResizerElement = 17647,
  XULTextElement = 17665,
  XULTreeElement = 17680,
  console = 17695,
  webkitSpeechGrammar = 17703,
  webkitSpeechGrammarList = 17723,
  webkitSpeechRecognition = 17747,
  webkitURL = 17771,
};

namespace binding_detail {
extern const char sBindingNames[];
}  // namespace binding_detail

MOZ_ALWAYS_INLINE const char* BindingName(BindingNamesOffset aOffset) {
  return binding_detail::sBindingNames + static_cast<size_t>(aOffset);
}

} // namespace mozilla::dom


#endif // DOM_BINDINGNAMES_H_
