/* THIS FILE IS AUTOGENERATED FROM MediaKeyStatusMap.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_MediaKeyStatusMapBinding_h
#define mozilla_dom_MediaKeyStatusMapBinding_h

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

class MediaKeyStatusMap;
struct NativePropertyHooks;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

enum class MediaKeyStatus : uint8_t {
  Usable,
  Expired,
  Released,
  Output_restricted,
  Output_downscaled,
  Status_pending,
  Internal_error,
  EndGuard_
};

namespace MediaKeyStatusValues {
extern const EnumEntry strings[8];

static constexpr size_t Count = 7;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(MediaKeyStatus::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(MediaKeyStatus stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace MediaKeyStatusValues

bool
ToJSValue(JSContext* aCx, MediaKeyStatus aArgument, JS::MutableHandle<JS::Value> aValue);


class MediaKeyStatusOrUndefined
{
  enum TypeOrUninit
  {
    eUninitialized,
    eMediaKeyStatus,
    eUndefined
  };
public:
  enum class Type
  {
    eMediaKeyStatus = TypeOrUninit::eMediaKeyStatus,
    eUndefined = TypeOrUninit::eUndefined
  };

private:
  union Value
  {
    UnionMember<MediaKeyStatus > mMediaKeyStatus;

  };

  TypeOrUninit mType;
  Value mValue;

  MediaKeyStatusOrUndefined(const MediaKeyStatusOrUndefined&) = delete;
  MediaKeyStatusOrUndefined& operator=(const MediaKeyStatusOrUndefined&) = delete;
public:
  explicit inline MediaKeyStatusOrUndefined()
    : mType(eUninitialized)
  {
  }

  inline ~MediaKeyStatusOrUndefined()
  {
    Uninit();
  }

  inline MediaKeyStatus&
  RawSetAsMediaKeyStatus()
  {
    if (mType == eMediaKeyStatus) {
      return mValue.mMediaKeyStatus.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eMediaKeyStatus;
    return mValue.mMediaKeyStatus.SetValue();
  }

  inline MediaKeyStatus&
  SetAsMediaKeyStatus()
  {
    if (mType == eMediaKeyStatus) {
      return mValue.mMediaKeyStatus.Value();
    }
    Uninit();
    mType = eMediaKeyStatus;
    return mValue.mMediaKeyStatus.SetValue();
  }

  inline bool
  IsMediaKeyStatus() const
  {
    return mType == eMediaKeyStatus;
  }

  inline MediaKeyStatus&
  GetAsMediaKeyStatus()
  {
    MOZ_RELEASE_ASSERT(IsMediaKeyStatus(), "Wrong type!");
    return mValue.mMediaKeyStatus.Value();
  }

  inline MediaKeyStatus
  GetAsMediaKeyStatus() const
  {
    MOZ_RELEASE_ASSERT(IsMediaKeyStatus(), "Wrong type!");
    return mValue.mMediaKeyStatus.Value();
  }

  inline bool
  IsUndefined() const
  {
    return mType == eUndefined;
  }

  inline void
  SetUndefined()
  {
    Uninit();
    mType = eUndefined;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eMediaKeyStatus: {
        DestroyMediaKeyStatus();
        break;
      }
      case eUndefined: {
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToMediaKeyStatus(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToMediaKeyStatus(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyMediaKeyStatus()
  {
    MOZ_RELEASE_ASSERT(IsMediaKeyStatus(), "Wrong type!");
    mValue.mMediaKeyStatus.Destroy();
    mType = eUninitialized;
  }
};


class OwningMediaKeyStatusOrUndefined : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eMediaKeyStatus,
    eUndefined
  };
public:
  enum class Type
  {
    eMediaKeyStatus = TypeOrUninit::eMediaKeyStatus,
    eUndefined = TypeOrUninit::eUndefined
  };

private:
  union Value
  {
    UnionMember<MediaKeyStatus > mMediaKeyStatus;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningMediaKeyStatusOrUndefined()
    : mType(eUninitialized)
  {
  }

  OwningMediaKeyStatusOrUndefined(OwningMediaKeyStatusOrUndefined&& aOther);

  explicit inline OwningMediaKeyStatusOrUndefined(const OwningMediaKeyStatusOrUndefined& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningMediaKeyStatusOrUndefined()
  {
    Uninit();
  }

  MediaKeyStatus&
  RawSetAsMediaKeyStatus();

  MediaKeyStatus&
  SetAsMediaKeyStatus();

  inline bool
  IsMediaKeyStatus() const
  {
    return mType == eMediaKeyStatus;
  }

  inline MediaKeyStatus&
  GetAsMediaKeyStatus()
  {
    MOZ_RELEASE_ASSERT(IsMediaKeyStatus(), "Wrong type!");
    return mValue.mMediaKeyStatus.Value();
  }

  inline MediaKeyStatus const &
  GetAsMediaKeyStatus() const
  {
    MOZ_RELEASE_ASSERT(IsMediaKeyStatus(), "Wrong type!");
    return mValue.mMediaKeyStatus.Value();
  }

  inline bool
  IsUndefined() const
  {
    return mType == eUndefined;
  }

  inline void
  SetUndefined()
  {
    Uninit();
    mType = eUndefined;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningMediaKeyStatusOrUndefined&
  operator=(OwningMediaKeyStatusOrUndefined&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningMediaKeyStatusOrUndefined&
  operator=(const OwningMediaKeyStatusOrUndefined& aOther);

private:
  bool
  TrySetToMediaKeyStatus(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToMediaKeyStatus(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyMediaKeyStatus();
};




namespace MediaKeyStatusMap_Binding {

  typedef mozilla::dom::MediaKeyStatusMap NativeType;

  bool
  Wrap(JSContext* aCx, mozilla::dom::MediaKeyStatusMap* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::MediaKeyStatusMap,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::MediaKeyStatusMap,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::MediaKeyStatusMap,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace MediaKeyStatusMap_Binding






} // namespace mozilla::dom

#endif // mozilla_dom_MediaKeyStatusMapBinding_h
