/* THIS FILE IS AUTOGENERATED FROM InstallTrigger.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_INSTALLTRIGGERBINDING_H_
#define DOM_INSTALLTRIGGERBINDING_H_

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/CallbackFunction.h"
#include "mozilla/dom/CallbackInterface.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/Record.h"
#include "mozilla/dom/ToJSValue.h"
#include "mozilla/dom/UnionMember.h"
#include "nsWeakReference.h"

namespace mozilla {
namespace dom {

class InstallTriggerCallback;
struct InstallTriggerDataAtoms;
class InstallTriggerImpl;
struct InstallTriggerImplAtoms;
struct NativePropertyHooks;
class OwningStringOrInstallTriggerData;
class ProtoAndIfaceCache;
class StringOrInstallTriggerData;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

class InstallTriggerCallback : public CallbackFunction
{
public:
  explicit inline InstallTriggerCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline InstallTriggerCallback(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline InstallTriggerCallback(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline InstallTriggerCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, const nsAString& url, int16_t status, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "InstallTriggerCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetCallContext(), thisValJS, url, status, aRv);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(const nsAString& url, int16_t status, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "InstallTriggerCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, url, status, aRv);
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, const nsAString& url, int16_t status, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, url, status, IgnoreErrors(), aExecutionReason);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(const nsAString& url, int16_t status, const char* aExecutionReason = nullptr)
  {
    return Call(url, status, IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const InstallTriggerCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  MOZ_CAN_RUN_SCRIPT void Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, const nsAString& url, int16_t status, ErrorResult& aRv);
};


namespace binding_detail {
class FastInstallTriggerCallback : public InstallTriggerCallback
{
public:
  explicit inline FastInstallTriggerCallback(JSObject* aCallback, JSObject* aCallbackGlobal)
    : InstallTriggerCallback(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    InstallTriggerCallback::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    InstallTriggerCallback::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


struct InstallTriggerData : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mHash;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mIconURL;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mURL;

  InstallTriggerData();

  explicit inline InstallTriggerData(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  InstallTriggerData(InstallTriggerData&& aOther) = default;

  explicit inline InstallTriggerData(const InstallTriggerData& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  InstallTriggerData&
  operator=(const InstallTriggerData& aOther);

private:
  static bool
  InitIds(JSContext* cx, InstallTriggerDataAtoms* atomsCache);
};

namespace binding_detail {
struct FastInstallTriggerData : public InstallTriggerData
{
  inline FastInstallTriggerData()
    : InstallTriggerData(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class StringOrInstallTriggerData : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eInstallTriggerData
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eInstallTriggerData = TypeOrUninit::eInstallTriggerData
  };

private:
  union Value
  {
    UnionMember<binding_detail::FakeString<char16_t> > mString;
    UnionMember<binding_detail::FastInstallTriggerData > mInstallTriggerData;

  };

  TypeOrUninit mType;
  Value mValue;

  StringOrInstallTriggerData(const StringOrInstallTriggerData&) = delete;
  StringOrInstallTriggerData& operator=(const StringOrInstallTriggerData&) = delete;
public:
  explicit inline StringOrInstallTriggerData()
    : mType(eUninitialized)
  {
  }

  inline ~StringOrInstallTriggerData()
  {
    Uninit();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  [[nodiscard]] inline binding_detail::FastInstallTriggerData&
  RawSetAsInstallTriggerData()
  {
    if (mType == eInstallTriggerData) {
      return mValue.mInstallTriggerData.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eInstallTriggerData;
    return mValue.mInstallTriggerData.SetValue();
  }

  [[nodiscard]] inline binding_detail::FastInstallTriggerData&
  SetAsInstallTriggerData()
  {
    if (mType == eInstallTriggerData) {
      return mValue.mInstallTriggerData.Value();
    }
    Uninit();
    mType = eInstallTriggerData;
    return mValue.mInstallTriggerData.SetValue();
  }

  inline bool
  IsInstallTriggerData() const
  {
    return mType == eInstallTriggerData;
  }

  inline binding_detail::FastInstallTriggerData&
  GetAsInstallTriggerData()
  {
    MOZ_RELEASE_ASSERT(IsInstallTriggerData(), "Wrong type!");
    return mValue.mInstallTriggerData.Value();
  }

  inline const InstallTriggerData&
  GetAsInstallTriggerData() const
  {
    MOZ_RELEASE_ASSERT(IsInstallTriggerData(), "Wrong type!");
    return mValue.mInstallTriggerData.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
      case eInstallTriggerData: {
        DestroyInstallTriggerData();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToInstallTriggerData(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToInstallTriggerData(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyInstallTriggerData()
  {
    MOZ_RELEASE_ASSERT(IsInstallTriggerData(), "Wrong type!");
    mValue.mInstallTriggerData.Destroy();
    mType = eUninitialized;
  }
};


class OwningStringOrInstallTriggerData : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eString,
    eInstallTriggerData
  };
public:
  enum class Type
  {
    eString = TypeOrUninit::eString,
    eInstallTriggerData = TypeOrUninit::eInstallTriggerData
  };

private:
  union Value
  {
    UnionMember<nsString > mString;
    UnionMember<InstallTriggerData > mInstallTriggerData;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningStringOrInstallTriggerData()
    : mType(eUninitialized)
  {
  }

  OwningStringOrInstallTriggerData(OwningStringOrInstallTriggerData&& aOther);

  explicit inline OwningStringOrInstallTriggerData(const OwningStringOrInstallTriggerData& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningStringOrInstallTriggerData()
  {
    Uninit();
  }

  [[nodiscard]] nsString&
  RawSetAsString();

  [[nodiscard]] nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  [[nodiscard]] InstallTriggerData&
  RawSetAsInstallTriggerData();

  [[nodiscard]] InstallTriggerData&
  SetAsInstallTriggerData();

  inline bool
  IsInstallTriggerData() const
  {
    return mType == eInstallTriggerData;
  }

  inline InstallTriggerData&
  GetAsInstallTriggerData()
  {
    MOZ_RELEASE_ASSERT(IsInstallTriggerData(), "Wrong type!");
    return mValue.mInstallTriggerData.Value();
  }

  inline InstallTriggerData const &
  GetAsInstallTriggerData() const
  {
    MOZ_RELEASE_ASSERT(IsInstallTriggerData(), "Wrong type!");
    return mValue.mInstallTriggerData.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningStringOrInstallTriggerData&
  operator=(OwningStringOrInstallTriggerData&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningStringOrInstallTriggerData&
  operator=(const OwningStringOrInstallTriggerData& aOther);

private:
  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();

  bool
  TrySetToInstallTriggerData(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToInstallTriggerData(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyInstallTriggerData();
};


namespace InstallTriggerImpl_Binding {

  typedef mozilla::dom::InstallTriggerImpl NativeType;

  static const uint16_t SKIN = 1;
  static const uint16_t LOCALE = 2;
  static const uint16_t CONTENT = 4;
  static const uint16_t PACKAGE = 7;
  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::InstallTriggerImpl* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::InstallTriggerImpl,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace InstallTriggerImpl_Binding



class InstallTriggerImplJSImpl : public CallbackInterface
{
public:
  explicit inline InstallTriggerImplJSImpl(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
  }

  explicit inline InstallTriggerImplJSImpl(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackInterface(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  explicit inline InstallTriggerImplJSImpl(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
  }

  bool Enabled(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  bool UpdateEnabled(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  bool Install(const Record<nsString, OwningStringOrInstallTriggerData>& installs, const Optional<OwningNonNull<InstallTriggerCallback>>& callback, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  bool InstallChrome(uint16_t type, const nsAString& url, const nsAString& skin, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  bool StartSoftwareUpdate(const nsAString& url, const Optional<uint16_t>& flags, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  inline bool
  operator==(const InstallTriggerImplJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

private:
  static bool
  InitIds(JSContext* cx, InstallTriggerImplAtoms* atomsCache);
};


class InstallTriggerImpl final : public nsSupportsWeakReference,
                                 public nsWrapperCache
{
public:
  NS_DECL_CYCLE_COLLECTING_ISUPPORTS
  NS_DECL_CYCLE_COLLECTION_WRAPPERCACHE_CLASS(InstallTriggerImpl)

private:
  RefPtr<InstallTriggerImplJSImpl> mImpl;
  nsCOMPtr<nsIGlobalObject> mParent;

public:
  InstallTriggerImpl(JS::Handle<JSObject*> aJSImplObject, JS::Handle<JSObject*> aJSImplGlobal, nsIGlobalObject* aParent);

private:
  ~InstallTriggerImpl();

public:
  nsISupports* GetParentObject() const;

  JSObject* WrapObject(JSContext* aCx, JS::Handle<JSObject*> aGivenProto) override;

  bool Enabled(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  bool UpdateEnabled(ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  bool Install(const Record<nsString, OwningStringOrInstallTriggerData>& installs, const Optional<OwningNonNull<InstallTriggerCallback>>& callback, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  bool InstallChrome(uint16_t type, const nsAString& url, const nsAString& skin, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  bool StartSoftwareUpdate(const nsAString& url, const Optional<uint16_t>& flags, ErrorResult& aRv, JS::Realm* aRealm = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


} // namespace mozilla::dom

#endif // DOM_INSTALLTRIGGERBINDING_H_
