/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/docshell/base/nsIDocShell.idl
 */

#ifndef __gen_nsIDocShell_h__
#define __gen_nsIDocShell_h__


#include "domstubs.h"

#include "nsIDocShellTreeItem.h"

#include "nsIRequest.h"

#include "nsTArray.h"

#include "js/Value.h"

#include "mozilla/AlreadyAddRefed.h"
#include "mozilla/Assertions.h"
#include "mozilla/DebugOnly.h"

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
#include "js/TypeDecls.h"
#include "mozilla/Maybe.h"
#include "mozilla/NotNull.h"
#include "mozilla/UniquePtr.h"
#include "nsCOMPtr.h"
#include "nsIURI.h"
class nsCommandManager;
class nsPresContext;
class nsDocShellLoadState;
namespace mozilla {
class Encoding;
class HTMLEditor;
class PresShell;
namespace dom {
class BrowsingContext;
class ClientSource;
} // namespace dom
}
class nsIURI; /* forward declaration */

class nsIChannel; /* forward declaration */

class nsIContentSecurityPolicy; /* forward declaration */

class nsIDocumentViewer; /* forward declaration */

class nsIEditor; /* forward declaration */

class nsIEditingSession; /* forward declaration */

class nsIInputStream; /* forward declaration */

class nsIRequest; /* forward declaration */

class nsISHEntry; /* forward declaration */

class nsILayoutHistoryState; /* forward declaration */

class nsISecureBrowserUI; /* forward declaration */

class nsIScriptGlobalObject; /* forward declaration */

class nsIStructuredCloneContainer; /* forward declaration */

class nsIDOMStorage; /* forward declaration */

class nsIPrincipal; /* forward declaration */

class nsIPrivacyTransitionObserver; /* forward declaration */

class nsIReflowObserver; /* forward declaration */

class nsIScrollObserver; /* forward declaration */

class nsIRemoteTab; /* forward declaration */

class nsIBrowserChild; /* forward declaration */

class nsICommandParams; /* forward declaration */

class nsILoadURIDelegate; /* forward declaration */

namespace mozilla {
namespace dom {
class BrowsingContext; /* webidl BrowsingContext */
} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {
class ContentFrameMessageManager; /* webidl ContentFrameMessageManager */
} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {
class EventTarget; /* webidl EventTarget */
} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {
class Document; /* webidl Document */
} // namespace dom
} // namespace mozilla


/* starting interface:    nsIDocShell */
#define NS_IDOCSHELL_IID_STR "049234fe-da10-478b-bc5d-bc6f9a1ba63d"

#define NS_IDOCSHELL_IID \
  {0x049234fe, 0xda10, 0x478b, \
    { 0xbc, 0x5d, 0xbc, 0x6f, 0x9a, 0x1b, 0xa6, 0x3d }}

class nsIDocShell : public nsIDocShellTreeItem {
 public:

  NS_INLINE_DECL_STATIC_IID(NS_IDOCSHELL_IID)

  /* Used by ToJSValue to check which scriptable interface is implemented. */
  using ScriptableInterfaceType = nsIDocShell;

  /* void setCancelContentJSEpoch (in long aEpoch); */
  NS_IMETHOD SetCancelContentJSEpoch(int32_t aEpoch) = 0;

  /* [noscript] void loadURI (in nsDocShellLoadStatePtr aLoadState, in boolean aSetNavigating); */
  NS_IMETHOD LoadURI(nsDocShellLoadState* aLoadState, bool aSetNavigating) = 0;

  /* [can_run_script,implicit_jscontext] void addState (in jsval aData, in AString aTitle, in AString aURL, in boolean aReplace); */
  MOZ_CAN_RUN_SCRIPT NS_IMETHOD AddState(JS::Handle<JS::Value> aData, const nsAString& aTitle, const nsAString& aURL, bool aReplace, JSContext* cx) = 0;

  /* void prepareForNewContentModel (); */
  NS_IMETHOD PrepareForNewContentModel(void) = 0;

  /* void setCurrentURIForSessionStore (in nsIURI aURI); */
  NS_IMETHOD SetCurrentURIForSessionStore(nsIURI *aURI) = 0;

  /* [noscript] void firePageHideNotification (in boolean isUnload); */
  NS_IMETHOD FirePageHideNotification(bool isUnload) = 0;

  /* [nostdcall,notxpcom] readonly attribute nsPresContext presContext; */
  virtual nsPresContext * GetPresContext() = 0;

  /* [nostdcall,notxpcom] readonly attribute PresShell presShell; */
  virtual mozilla::PresShell * GetPresShell() = 0;

  /* [nostdcall,notxpcom] readonly attribute PresShell eldestPresShell; */
  virtual mozilla::PresShell * GetEldestPresShell() = 0;

  /* [infallible] readonly attribute nsIDocumentViewer docViewer; */
  NS_IMETHOD GetDocViewer(nsIDocumentViewer **aDocViewer) = 0;
   inline already_AddRefed<nsIDocumentViewer> GetDocViewer()
  {
    nsIDocumentViewer* result = nullptr;
    mozilla::DebugOnly<nsresult> rv = GetDocViewer(&result);
    MOZ_ASSERT(NS_SUCCEEDED(rv));
    return already_AddRefed<nsIDocumentViewer>(result);
  }

  /* [infallible] readonly attribute unsigned long long outerWindowID; */
  NS_IMETHOD GetOuterWindowID(uint64_t *aOuterWindowID) = 0;
  inline uint64_t  GetOuterWindowID()
  {
    uint64_t result;
    mozilla::DebugOnly<nsresult> rv = GetOuterWindowID(&result);
    MOZ_ASSERT(NS_SUCCEEDED(rv));
    return result;
  }

  /* attribute EventTarget chromeEventHandler; */
  NS_IMETHOD GetChromeEventHandler(mozilla::dom::EventTarget **aChromeEventHandler) = 0;
  NS_IMETHOD SetChromeEventHandler(mozilla::dom::EventTarget *aChromeEventHandler) = 0;

  /* attribute AString customUserAgent; */
  NS_IMETHOD GetCustomUserAgent(nsAString& aCustomUserAgent) = 0;
  NS_IMETHOD SetCustomUserAgent(const nsAString& aCustomUserAgent) = 0;

  /* attribute boolean cssErrorReportingEnabled; */
  NS_IMETHOD GetCssErrorReportingEnabled(bool *aCssErrorReportingEnabled) = 0;
  NS_IMETHOD SetCssErrorReportingEnabled(bool aCssErrorReportingEnabled) = 0;

  /* attribute boolean allowMetaRedirects; */
  NS_IMETHOD GetAllowMetaRedirects(bool *aAllowMetaRedirects) = 0;
  NS_IMETHOD SetAllowMetaRedirects(bool aAllowMetaRedirects) = 0;

  /* attribute boolean allowSubframes; */
  NS_IMETHOD GetAllowSubframes(bool *aAllowSubframes) = 0;
  NS_IMETHOD SetAllowSubframes(bool aAllowSubframes) = 0;

  /* attribute boolean allowImages; */
  NS_IMETHOD GetAllowImages(bool *aAllowImages) = 0;
  NS_IMETHOD SetAllowImages(bool aAllowImages) = 0;

  /* [infallible] attribute boolean allowMedia; */
  NS_IMETHOD GetAllowMedia(bool *aAllowMedia) = 0;
  inline bool  GetAllowMedia()
  {
    bool result;
    mozilla::DebugOnly<nsresult> rv = GetAllowMedia(&result);
    MOZ_ASSERT(NS_SUCCEEDED(rv));
    return result;
  }
  NS_IMETHOD SetAllowMedia(bool aAllowMedia) = 0;

  /* attribute boolean allowDNSPrefetch; */
  NS_IMETHOD GetAllowDNSPrefetch(bool *aAllowDNSPrefetch) = 0;
  NS_IMETHOD SetAllowDNSPrefetch(bool aAllowDNSPrefetch) = 0;

  /* attribute boolean allowWindowControl; */
  NS_IMETHOD GetAllowWindowControl(bool *aAllowWindowControl) = 0;
  NS_IMETHOD SetAllowWindowControl(bool aAllowWindowControl) = 0;

  /* [infallible] attribute boolean allowContentRetargeting; */
  NS_IMETHOD GetAllowContentRetargeting(bool *aAllowContentRetargeting) = 0;
  inline bool  GetAllowContentRetargeting()
  {
    bool result;
    mozilla::DebugOnly<nsresult> rv = GetAllowContentRetargeting(&result);
    MOZ_ASSERT(NS_SUCCEEDED(rv));
    return result;
  }
  NS_IMETHOD SetAllowContentRetargeting(bool aAllowContentRetargeting) = 0;

  /* [infallible] attribute boolean allowContentRetargetingOnChildren; */
  NS_IMETHOD GetAllowContentRetargetingOnChildren(bool *aAllowContentRetargetingOnChildren) = 0;
  inline bool  GetAllowContentRetargetingOnChildren()
  {
    bool result;
    mozilla::DebugOnly<nsresult> rv = GetAllowContentRetargetingOnChildren(&result);
    MOZ_ASSERT(NS_SUCCEEDED(rv));
    return result;
  }
  NS_IMETHOD SetAllowContentRetargetingOnChildren(bool aAllowContentRetargetingOnChildren) = 0;

  enum DocShellEnumeratorDirection : uint8_t {
    ENUMERATE_FORWARDS = 0,
    ENUMERATE_BACKWARDS = 1,
  };

  /* Array<nsIDocShell> getAllDocShellsInSubtree (in long aItemType, in nsIDocShell_DocShellEnumeratorDirection aDirection); */
  NS_IMETHOD GetAllDocShellsInSubtree(int32_t aItemType, nsIDocShell::DocShellEnumeratorDirection aDirection, nsTArray<RefPtr<nsIDocShell>>& _retval) = 0;

  enum AppType : uint8_t {
    APP_TYPE_UNKNOWN = 0,
    APP_TYPE_MAIL = 1,
    APP_TYPE_EDITOR = 2,
  };

  /* [infallible] attribute nsIDocShell_AppType appType; */
  NS_IMETHOD GetAppType(nsIDocShell::AppType *aAppType) = 0;
  inline nsIDocShell::AppType  GetAppType()
  {
    nsIDocShell::AppType result;
    mozilla::DebugOnly<nsresult> rv = GetAppType(&result);
    MOZ_ASSERT(NS_SUCCEEDED(rv));
    return result;
  }
  NS_IMETHOD SetAppType(nsIDocShell::AppType aAppType) = 0;

  /* attribute boolean allowAuth; */
  NS_IMETHOD GetAllowAuth(bool *aAllowAuth) = 0;
  NS_IMETHOD SetAllowAuth(bool aAllowAuth) = 0;

  /* attribute float zoom; */
  NS_IMETHOD GetZoom(float *aZoom) = 0;
  NS_IMETHOD SetZoom(float aZoom) = 0;

  enum BusyFlags : uint8_t {
    BUSY_FLAGS_NONE = 0,
    BUSY_FLAGS_BUSY = 1,
    BUSY_FLAGS_BEFORE_PAGE_LOAD = 2,
    BUSY_FLAGS_PAGE_LOADING = 4,
  };

  /* [infallible] readonly attribute nsIDocShell_BusyFlags busyFlags; */
  NS_IMETHOD GetBusyFlags(nsIDocShell::BusyFlags *aBusyFlags) = 0;
  inline nsIDocShell::BusyFlags  GetBusyFlags()
  {
    nsIDocShell::BusyFlags result;
    mozilla::DebugOnly<nsresult> rv = GetBusyFlags(&result);
    MOZ_ASSERT(NS_SUCCEEDED(rv));
    return result;
  }

  enum LoadCommand : uint8_t {
    LOAD_CMD_NORMAL = 1,
    LOAD_CMD_RELOAD = 2,
    LOAD_CMD_HISTORY = 4,
    LOAD_CMD_PUSHSTATE = 8,
  };

  /* [infallible] attribute unsigned long loadType; */
  NS_IMETHOD GetLoadType(uint32_t *aLoadType) = 0;
  inline uint32_t  GetLoadType()
  {
    uint32_t result;
    mozilla::DebugOnly<nsresult> rv = GetLoadType(&result);
    MOZ_ASSERT(NS_SUCCEEDED(rv));
    return result;
  }
  NS_IMETHOD SetLoadType(uint32_t aLoadType) = 0;

  /* attribute nsLoadFlags defaultLoadFlags; */
  NS_IMETHOD GetDefaultLoadFlags(nsLoadFlags *aDefaultLoadFlags) = 0;
  NS_IMETHOD SetDefaultLoadFlags(nsLoadFlags aDefaultLoadFlags) = 0;

  /* boolean isBeingDestroyed (); */
  NS_IMETHOD IsBeingDestroyed(bool *_retval) = 0;

  /* readonly attribute boolean isExecutingOnLoadHandler; */
  NS_IMETHOD GetIsExecutingOnLoadHandler(bool *aIsExecutingOnLoadHandler) = 0;

  /* attribute nsILayoutHistoryState layoutHistoryState; */
  NS_IMETHOD GetLayoutHistoryState(nsILayoutHistoryState **aLayoutHistoryState) = 0;
  NS_IMETHOD SetLayoutHistoryState(nsILayoutHistoryState *aLayoutHistoryState) = 0;

  /* readonly attribute nsILoadURIDelegate loadURIDelegate; */
  NS_IMETHOD GetLoadURIDelegate(nsILoadURIDelegate **aLoadURIDelegate) = 0;

  /* void suspendRefreshURIs (); */
  NS_IMETHOD SuspendRefreshURIs(void) = 0;

  /* void resumeRefreshURIs (); */
  NS_IMETHOD ResumeRefreshURIs(void) = 0;

  /* void beginRestore (in nsIDocumentViewer viewer, in boolean top); */
  NS_IMETHOD BeginRestore(nsIDocumentViewer *viewer, bool top) = 0;

  /* void finishRestore (); */
  NS_IMETHOD FinishRestore(void) = 0;

  /* void clearCachedUserAgent (); */
  NS_IMETHOD ClearCachedUserAgent(void) = 0;

  /* void clearCachedPlatform (); */
  NS_IMETHOD ClearCachedPlatform(void) = 0;

  /* readonly attribute boolean restoringDocument; */
  NS_IMETHOD GetRestoringDocument(bool *aRestoringDocument) = 0;

  /* attribute boolean useErrorPages; */
  NS_IMETHOD GetUseErrorPages(bool *aUseErrorPages) = 0;
  NS_IMETHOD SetUseErrorPages(bool aUseErrorPages) = 0;

  /* boolean displayLoadError (in nsresult aError, in nsIURI aURI, in wstring aURL, [optional] in nsIChannel aFailedChannel); */
  NS_IMETHOD DisplayLoadError(nsresult aError, nsIURI *aURI, const char16_t * aURL, nsIChannel *aFailedChannel, bool *_retval) = 0;

  /* readonly attribute nsIChannel failedChannel; */
  NS_IMETHOD GetFailedChannel(nsIChannel **aFailedChannel) = 0;

  /* readonly attribute long previousEntryIndex; */
  NS_IMETHOD GetPreviousEntryIndex(int32_t *aPreviousEntryIndex) = 0;

  /* readonly attribute long loadedEntryIndex; */
  NS_IMETHOD GetLoadedEntryIndex(int32_t *aLoadedEntryIndex) = 0;

  /* void historyPurged (in long numEntries); */
  NS_IMETHOD HistoryPurged(int32_t numEntries) = 0;

  /* readonly attribute nsIChannel currentDocumentChannel; */
  NS_IMETHOD GetCurrentDocumentChannel(nsIChannel **aCurrentDocumentChannel) = 0;

  /* [infallible] readonly attribute boolean isInUnload; */
  NS_IMETHOD GetIsInUnload(bool *aIsInUnload) = 0;
  inline bool  GetIsInUnload()
  {
    bool result;
    mozilla::DebugOnly<nsresult> rv = GetIsInUnload(&result);
    MOZ_ASSERT(NS_SUCCEEDED(rv));
    return result;
  }

  /* [noscript,notxpcom] void DetachEditorFromWindow (); */
  NS_IMETHOD_(void) DetachEditorFromWindow(void) = 0;

  /* void exitPrintPreview (); */
  NS_IMETHOD ExitPrintPreview(void) = 0;

  /* readonly attribute nsIDRef historyID; */
  NS_IMETHOD GetHistoryID(nsID & aHistoryID) = 0;

  /* [noscript,notxpcom] nsIDRef HistoryID (); */
  NS_IMETHOD_(const nsID &) HistoryID(void) = 0;

  /* void createAboutBlankDocumentViewer (in nsIPrincipal aPrincipal, in nsIPrincipal aPartitionedPrincipal, [optional] in nsIContentSecurityPolicy aCSP); */
  NS_IMETHOD CreateAboutBlankDocumentViewer(nsIPrincipal *aPrincipal, nsIPrincipal *aPartitionedPrincipal, nsIContentSecurityPolicy *aCSP) = 0;

  /* readonly attribute ACString charset; */
  NS_IMETHOD GetCharset(nsACString& aCharset) = 0;

  /* void forceEncodingDetection (); */
  NS_IMETHOD ForceEncodingDetection(void) = 0;

  /* [noscript,nostdcall,notxpcom] void setParentCharset (in Encoding parentCharset, in int32_t parentCharsetSource, in nsIPrincipal parentCharsetPrincipal); */
  virtual void SetParentCharset(const mozilla::Encoding* & parentCharset, int32_t parentCharsetSource, nsIPrincipal *parentCharsetPrincipal) = 0;

  /* [noscript,nostdcall,notxpcom] void getParentCharset (out Encoding parentCharset, out int32_t parentCharsetSource, out nsIPrincipal parentCharsetPrincipal); */
  virtual void GetParentCharset(const mozilla::Encoding* & parentCharset, int32_t *parentCharsetSource, nsIPrincipal **parentCharsetPrincipal) = 0;

  /* DOMHighResTimeStamp now (); */
  NS_IMETHOD Now(DOMHighResTimeStamp *_retval) = 0;

  /* void addWeakPrivacyTransitionObserver (in nsIPrivacyTransitionObserver obs); */
  NS_IMETHOD AddWeakPrivacyTransitionObserver(nsIPrivacyTransitionObserver *obs) = 0;

  /* void addWeakReflowObserver (in nsIReflowObserver obs); */
  NS_IMETHOD AddWeakReflowObserver(nsIReflowObserver *obs) = 0;

  /* void removeWeakReflowObserver (in nsIReflowObserver obs); */
  NS_IMETHOD RemoveWeakReflowObserver(nsIReflowObserver *obs) = 0;

  /* [noscript] void notifyReflowObservers (in boolean interruptible, in DOMHighResTimeStamp start, in DOMHighResTimeStamp end); */
  NS_IMETHOD NotifyReflowObservers(bool interruptible, DOMHighResTimeStamp start, DOMHighResTimeStamp end) = 0;

  /* [noscript] void addWeakScrollObserver (in nsIScrollObserver obs); */
  NS_IMETHOD AddWeakScrollObserver(nsIScrollObserver *obs) = 0;

  /* [noscript] void removeWeakScrollObserver (in nsIScrollObserver obs); */
  NS_IMETHOD RemoveWeakScrollObserver(nsIScrollObserver *obs) = 0;

  /* [noscript] void notifyScrollObservers (); */
  NS_IMETHOD NotifyScrollObservers(void) = 0;

  /* [infallible] readonly attribute boolean isTopLevelContentDocShell; */
  NS_IMETHOD GetIsTopLevelContentDocShell(bool *aIsTopLevelContentDocShell) = 0;
  inline bool  GetIsTopLevelContentDocShell()
  {
    bool result;
    mozilla::DebugOnly<nsresult> rv = GetIsTopLevelContentDocShell(&result);
    MOZ_ASSERT(NS_SUCCEEDED(rv));
    return result;
  }

  /* readonly attribute boolean asyncPanZoomEnabled; */
  NS_IMETHOD GetAsyncPanZoomEnabled(bool *aAsyncPanZoomEnabled) = 0;

  /* [infallible] readonly attribute boolean mayEnableCharacterEncodingMenu; */
  NS_IMETHOD GetMayEnableCharacterEncodingMenu(bool *aMayEnableCharacterEncodingMenu) = 0;
  inline bool  GetMayEnableCharacterEncodingMenu()
  {
    bool result;
    mozilla::DebugOnly<nsresult> rv = GetMayEnableCharacterEncodingMenu(&result);
    MOZ_ASSERT(NS_SUCCEEDED(rv));
    return result;
  }

  /* attribute nsIEditor editor; */
  NS_IMETHOD GetEditor(nsIEditor **aEditor) = 0;
  NS_IMETHOD SetEditor(nsIEditor *aEditor) = 0;

  /* readonly attribute boolean editable; */
  NS_IMETHOD GetEditable(bool *aEditable) = 0;

  /* readonly attribute boolean hasEditingSession; */
  NS_IMETHOD GetHasEditingSession(bool *aHasEditingSession) = 0;

  /* void makeEditable (in boolean inWaitForUriLoad); */
  NS_IMETHOD MakeEditable(bool inWaitForUriLoad) = 0;

  /* boolean getCurrentSHEntry (out nsISHEntry aEntry); */
  NS_IMETHOD GetCurrentSHEntry(nsISHEntry **aEntry, bool *_retval) = 0;

  /* boolean isCommandEnabled (in string command); */
  NS_IMETHOD IsCommandEnabled(const char * command, bool *_retval) = 0;

  /* [can_run_script] void doCommand (in string command); */
  MOZ_CAN_RUN_SCRIPT NS_IMETHOD DoCommand(const char * command) = 0;

  /* [can_run_script] void doCommandWithParams (in string command, in nsICommandParams aParams); */
  MOZ_CAN_RUN_SCRIPT NS_IMETHOD DoCommandWithParams(const char * command, nsICommandParams *aParams) = 0;

  /* [noscript,notxpcom] boolean IsInvisible (); */
  NS_IMETHOD_(bool) IsInvisible(void) = 0;

  /* [noscript,notxpcom] void SetInvisible (in boolean aIsInvisibleDocshell); */
  NS_IMETHOD_(void) SetInvisible(bool aIsInvisibleDocshell) = 0;

  /* [noscript,nostdcall,notxpcom] nsIScriptGlobalObject GetScriptGlobalObject (); */
  virtual nsIScriptGlobalObject * GetScriptGlobalObject(void) = 0;

  /* [noscript,nostdcall,notxpcom] Document getExtantDocument (); */
  virtual mozilla::dom::Document * GetExtantDocument(void) = 0;

  /* [infallible] readonly attribute boolean hasLoadedNonBlankURI; */
  NS_IMETHOD GetHasLoadedNonBlankURI(bool *aHasLoadedNonBlankURI) = 0;
  inline bool  GetHasLoadedNonBlankURI()
  {
    bool result;
    mozilla::DebugOnly<nsresult> rv = GetHasLoadedNonBlankURI(&result);
    MOZ_ASSERT(NS_SUCCEEDED(rv));
    return result;
  }

  /* attribute boolean windowDraggingAllowed; */
  NS_IMETHOD GetWindowDraggingAllowed(bool *aWindowDraggingAllowed) = 0;
  NS_IMETHOD SetWindowDraggingAllowed(bool aWindowDraggingAllowed) = 0;

  /* attribute boolean currentScrollRestorationIsManual; */
  NS_IMETHOD GetCurrentScrollRestorationIsManual(bool *aCurrentScrollRestorationIsManual) = 0;
  NS_IMETHOD SetCurrentScrollRestorationIsManual(bool aCurrentScrollRestorationIsManual) = 0;

  /* [implicit_jscontext] jsval getOriginAttributes (); */
  NS_IMETHOD GetOriginAttributes(JSContext* cx, JS::MutableHandle<JS::Value> _retval) = 0;

  /* [implicit_jscontext] void setOriginAttributes (in jsval aAttrs); */
  NS_IMETHOD SetOriginAttributes(JS::Handle<JS::Value> aAttrs, JSContext* cx) = 0;

  /* readonly attribute nsIEditingSession editingSession; */
  NS_IMETHOD GetEditingSession(nsIEditingSession **aEditingSession) = 0;

  /* [binaryname(ScriptableBrowserChild)] readonly attribute nsIBrowserChild browserChild; */
  NS_IMETHOD GetScriptableBrowserChild(nsIBrowserChild **aBrowserChild) = 0;

  /* [noscript,nostdcall,notxpcom] BrowserChildRef GetBrowserChild (); */
  virtual already_AddRefed<nsIBrowserChild> GetBrowserChild(void) = 0;

  /* [noscript,nostdcall,notxpcom] nsCommandManager GetCommandManager (); */
  virtual nsCommandManager * GetCommandManager(void) = 0;

  /* attribute boolean useTrackingProtection; */
  NS_IMETHOD GetUseTrackingProtection(bool *aUseTrackingProtection) = 0;
  NS_IMETHOD SetUseTrackingProtection(bool aUseTrackingProtection) = 0;

  /* [noscript] void dispatchLocationChangeEvent (); */
  NS_IMETHOD DispatchLocationChangeEvent(void) = 0;

  /* [noscript] void startDelayedAutoplayMediaComponents (); */
  NS_IMETHOD StartDelayedAutoplayMediaComponents(void) = 0;

  /* [noscript,nostdcall,notxpcom] UniqueClientSource TakeInitialClientSource (); */
  virtual mozilla::UniquePtr<mozilla::dom::ClientSource> TakeInitialClientSource(void) = 0;

  /* void setColorMatrix (in Array<float> aMatrix); */
  NS_IMETHOD SetColorMatrix(const nsTArray<float >& aMatrix) = 0;

  /* readonly attribute boolean isForceReloading; */
  NS_IMETHOD GetIsForceReloading(bool *aIsForceReloading) = 0;

  /* Array<float> getColorMatrix (); */
  NS_IMETHOD GetColorMatrix(nsTArray<float >& _retval) = 0;

   /**
   * These methods call nsDocShell::GetHTMLEditorInternal() and
   * nsDocShell::SetHTMLEditorInternal() with static_cast.
   */
  mozilla::HTMLEditor* GetHTMLEditor();
  nsresult SetHTMLEditor(mozilla::HTMLEditor* aHTMLEditor);
  /* [infallible] readonly attribute ContentFrameMessageManager messageManager; */
  NS_IMETHOD GetMessageManager(mozilla::dom::ContentFrameMessageManager **aMessageManager) = 0;
   inline already_AddRefed<mozilla::dom::ContentFrameMessageManager> GetMessageManager()
  {
    mozilla::dom::ContentFrameMessageManager* result = nullptr;
    mozilla::DebugOnly<nsresult> rv = GetMessageManager(&result);
    MOZ_ASSERT(NS_SUCCEEDED(rv));
    return already_AddRefed<mozilla::dom::ContentFrameMessageManager>(result);
  }

  /* Promise getHasTrackingContentBlocked (); */
  NS_IMETHOD GetHasTrackingContentBlocked(::mozilla::dom::Promise * * _retval) = 0;

  /* [nostdcall,notxpcom] readonly attribute boolean isAttemptingToNavigate; */
  virtual bool GetIsAttemptingToNavigate() = 0;

  /* [infallible] readonly attribute boolean isNavigating; */
  NS_IMETHOD GetIsNavigating(bool *aIsNavigating) = 0;
  inline bool  GetIsNavigating()
  {
    bool result;
    mozilla::DebugOnly<nsresult> rv = GetIsNavigating(&result);
    MOZ_ASSERT(NS_SUCCEEDED(rv));
    return result;
  }

  /* void synchronizeLayoutHistoryState (); */
  NS_IMETHOD SynchronizeLayoutHistoryState(void) = 0;

  /* void persistLayoutHistoryState (); */
  NS_IMETHOD PersistLayoutHistoryState(void) = 0;

};


/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIDOCSHELL \
  NS_IMETHOD SetCancelContentJSEpoch(int32_t aEpoch) override; \
  NS_IMETHOD LoadURI(nsDocShellLoadState* aLoadState, bool aSetNavigating) override; \
  MOZ_CAN_RUN_SCRIPT NS_IMETHOD AddState(JS::Handle<JS::Value> aData, const nsAString& aTitle, const nsAString& aURL, bool aReplace, JSContext* cx) override; \
  NS_IMETHOD PrepareForNewContentModel(void) override; \
  NS_IMETHOD SetCurrentURIForSessionStore(nsIURI *aURI) override; \
  NS_IMETHOD FirePageHideNotification(bool isUnload) override; \
  virtual nsPresContext * GetPresContext() override; \
  virtual mozilla::PresShell * GetPresShell() override; \
  virtual mozilla::PresShell * GetEldestPresShell() override; \
  using nsIDocShell::GetDocViewer; \
  NS_IMETHOD GetDocViewer(nsIDocumentViewer **aDocViewer) override; \
  using nsIDocShell::GetOuterWindowID; \
  NS_IMETHOD GetOuterWindowID(uint64_t *aOuterWindowID) override; \
  NS_IMETHOD GetChromeEventHandler(mozilla::dom::EventTarget **aChromeEventHandler) override; \
  NS_IMETHOD SetChromeEventHandler(mozilla::dom::EventTarget *aChromeEventHandler) override; \
  NS_IMETHOD GetCustomUserAgent(nsAString& aCustomUserAgent) override; \
  NS_IMETHOD SetCustomUserAgent(const nsAString& aCustomUserAgent) override; \
  NS_IMETHOD GetCssErrorReportingEnabled(bool *aCssErrorReportingEnabled) override; \
  NS_IMETHOD SetCssErrorReportingEnabled(bool aCssErrorReportingEnabled) override; \
  NS_IMETHOD GetAllowMetaRedirects(bool *aAllowMetaRedirects) override; \
  NS_IMETHOD SetAllowMetaRedirects(bool aAllowMetaRedirects) override; \
  NS_IMETHOD GetAllowSubframes(bool *aAllowSubframes) override; \
  NS_IMETHOD SetAllowSubframes(bool aAllowSubframes) override; \
  NS_IMETHOD GetAllowImages(bool *aAllowImages) override; \
  NS_IMETHOD SetAllowImages(bool aAllowImages) override; \
  using nsIDocShell::GetAllowMedia; \
  NS_IMETHOD GetAllowMedia(bool *aAllowMedia) override; \
  NS_IMETHOD SetAllowMedia(bool aAllowMedia) override; \
  NS_IMETHOD GetAllowDNSPrefetch(bool *aAllowDNSPrefetch) override; \
  NS_IMETHOD SetAllowDNSPrefetch(bool aAllowDNSPrefetch) override; \
  NS_IMETHOD GetAllowWindowControl(bool *aAllowWindowControl) override; \
  NS_IMETHOD SetAllowWindowControl(bool aAllowWindowControl) override; \
  using nsIDocShell::GetAllowContentRetargeting; \
  NS_IMETHOD GetAllowContentRetargeting(bool *aAllowContentRetargeting) override; \
  NS_IMETHOD SetAllowContentRetargeting(bool aAllowContentRetargeting) override; \
  using nsIDocShell::GetAllowContentRetargetingOnChildren; \
  NS_IMETHOD GetAllowContentRetargetingOnChildren(bool *aAllowContentRetargetingOnChildren) override; \
  NS_IMETHOD SetAllowContentRetargetingOnChildren(bool aAllowContentRetargetingOnChildren) override; \
  NS_IMETHOD GetAllDocShellsInSubtree(int32_t aItemType, nsIDocShell::DocShellEnumeratorDirection aDirection, nsTArray<RefPtr<nsIDocShell>>& _retval) override; \
  using nsIDocShell::GetAppType; \
  NS_IMETHOD GetAppType(nsIDocShell::AppType *aAppType) override; \
  NS_IMETHOD SetAppType(nsIDocShell::AppType aAppType) override; \
  NS_IMETHOD GetAllowAuth(bool *aAllowAuth) override; \
  NS_IMETHOD SetAllowAuth(bool aAllowAuth) override; \
  NS_IMETHOD GetZoom(float *aZoom) override; \
  NS_IMETHOD SetZoom(float aZoom) override; \
  using nsIDocShell::GetBusyFlags; \
  NS_IMETHOD GetBusyFlags(nsIDocShell::BusyFlags *aBusyFlags) override; \
  using nsIDocShell::GetLoadType; \
  NS_IMETHOD GetLoadType(uint32_t *aLoadType) override; \
  NS_IMETHOD SetLoadType(uint32_t aLoadType) override; \
  NS_IMETHOD GetDefaultLoadFlags(nsLoadFlags *aDefaultLoadFlags) override; \
  NS_IMETHOD SetDefaultLoadFlags(nsLoadFlags aDefaultLoadFlags) override; \
  NS_IMETHOD IsBeingDestroyed(bool *_retval) override; \
  NS_IMETHOD GetIsExecutingOnLoadHandler(bool *aIsExecutingOnLoadHandler) override; \
  NS_IMETHOD GetLayoutHistoryState(nsILayoutHistoryState **aLayoutHistoryState) override; \
  NS_IMETHOD SetLayoutHistoryState(nsILayoutHistoryState *aLayoutHistoryState) override; \
  NS_IMETHOD GetLoadURIDelegate(nsILoadURIDelegate **aLoadURIDelegate) override; \
  NS_IMETHOD SuspendRefreshURIs(void) override; \
  NS_IMETHOD ResumeRefreshURIs(void) override; \
  NS_IMETHOD BeginRestore(nsIDocumentViewer *viewer, bool top) override; \
  NS_IMETHOD FinishRestore(void) override; \
  NS_IMETHOD ClearCachedUserAgent(void) override; \
  NS_IMETHOD ClearCachedPlatform(void) override; \
  NS_IMETHOD GetRestoringDocument(bool *aRestoringDocument) override; \
  NS_IMETHOD GetUseErrorPages(bool *aUseErrorPages) override; \
  NS_IMETHOD SetUseErrorPages(bool aUseErrorPages) override; \
  NS_IMETHOD DisplayLoadError(nsresult aError, nsIURI *aURI, const char16_t * aURL, nsIChannel *aFailedChannel, bool *_retval) override; \
  NS_IMETHOD GetFailedChannel(nsIChannel **aFailedChannel) override; \
  NS_IMETHOD GetPreviousEntryIndex(int32_t *aPreviousEntryIndex) override; \
  NS_IMETHOD GetLoadedEntryIndex(int32_t *aLoadedEntryIndex) override; \
  NS_IMETHOD HistoryPurged(int32_t numEntries) override; \
  NS_IMETHOD GetCurrentDocumentChannel(nsIChannel **aCurrentDocumentChannel) override; \
  using nsIDocShell::GetIsInUnload; \
  NS_IMETHOD GetIsInUnload(bool *aIsInUnload) override; \
  NS_IMETHOD_(void) DetachEditorFromWindow(void) override; \
  NS_IMETHOD ExitPrintPreview(void) override; \
  NS_IMETHOD GetHistoryID(nsID & aHistoryID) override; \
  NS_IMETHOD_(const nsID &) HistoryID(void) override; \
  NS_IMETHOD CreateAboutBlankDocumentViewer(nsIPrincipal *aPrincipal, nsIPrincipal *aPartitionedPrincipal, nsIContentSecurityPolicy *aCSP) override; \
  NS_IMETHOD GetCharset(nsACString& aCharset) override; \
  NS_IMETHOD ForceEncodingDetection(void) override; \
  virtual void SetParentCharset(const mozilla::Encoding* & parentCharset, int32_t parentCharsetSource, nsIPrincipal *parentCharsetPrincipal) override; \
  virtual void GetParentCharset(const mozilla::Encoding* & parentCharset, int32_t *parentCharsetSource, nsIPrincipal **parentCharsetPrincipal) override; \
  NS_IMETHOD Now(DOMHighResTimeStamp *_retval) override; \
  NS_IMETHOD AddWeakPrivacyTransitionObserver(nsIPrivacyTransitionObserver *obs) override; \
  NS_IMETHOD AddWeakReflowObserver(nsIReflowObserver *obs) override; \
  NS_IMETHOD RemoveWeakReflowObserver(nsIReflowObserver *obs) override; \
  NS_IMETHOD NotifyReflowObservers(bool interruptible, DOMHighResTimeStamp start, DOMHighResTimeStamp end) override; \
  NS_IMETHOD AddWeakScrollObserver(nsIScrollObserver *obs) override; \
  NS_IMETHOD RemoveWeakScrollObserver(nsIScrollObserver *obs) override; \
  NS_IMETHOD NotifyScrollObservers(void) override; \
  using nsIDocShell::GetIsTopLevelContentDocShell; \
  NS_IMETHOD GetIsTopLevelContentDocShell(bool *aIsTopLevelContentDocShell) override; \
  NS_IMETHOD GetAsyncPanZoomEnabled(bool *aAsyncPanZoomEnabled) override; \
  using nsIDocShell::GetMayEnableCharacterEncodingMenu; \
  NS_IMETHOD GetMayEnableCharacterEncodingMenu(bool *aMayEnableCharacterEncodingMenu) override; \
  NS_IMETHOD GetEditor(nsIEditor **aEditor) override; \
  NS_IMETHOD SetEditor(nsIEditor *aEditor) override; \
  NS_IMETHOD GetEditable(bool *aEditable) override; \
  NS_IMETHOD GetHasEditingSession(bool *aHasEditingSession) override; \
  NS_IMETHOD MakeEditable(bool inWaitForUriLoad) override; \
  NS_IMETHOD GetCurrentSHEntry(nsISHEntry **aEntry, bool *_retval) override; \
  NS_IMETHOD IsCommandEnabled(const char * command, bool *_retval) override; \
  MOZ_CAN_RUN_SCRIPT NS_IMETHOD DoCommand(const char * command) override; \
  MOZ_CAN_RUN_SCRIPT NS_IMETHOD DoCommandWithParams(const char * command, nsICommandParams *aParams) override; \
  NS_IMETHOD_(bool) IsInvisible(void) override; \
  NS_IMETHOD_(void) SetInvisible(bool aIsInvisibleDocshell) override; \
  virtual nsIScriptGlobalObject * GetScriptGlobalObject(void) override; \
  virtual mozilla::dom::Document * GetExtantDocument(void) override; \
  using nsIDocShell::GetHasLoadedNonBlankURI; \
  NS_IMETHOD GetHasLoadedNonBlankURI(bool *aHasLoadedNonBlankURI) override; \
  NS_IMETHOD GetWindowDraggingAllowed(bool *aWindowDraggingAllowed) override; \
  NS_IMETHOD SetWindowDraggingAllowed(bool aWindowDraggingAllowed) override; \
  NS_IMETHOD GetCurrentScrollRestorationIsManual(bool *aCurrentScrollRestorationIsManual) override; \
  NS_IMETHOD SetCurrentScrollRestorationIsManual(bool aCurrentScrollRestorationIsManual) override; \
  NS_IMETHOD GetOriginAttributes(JSContext* cx, JS::MutableHandle<JS::Value> _retval) override; \
  NS_IMETHOD SetOriginAttributes(JS::Handle<JS::Value> aAttrs, JSContext* cx) override; \
  NS_IMETHOD GetEditingSession(nsIEditingSession **aEditingSession) override; \
  NS_IMETHOD GetScriptableBrowserChild(nsIBrowserChild **aBrowserChild) override; \
  virtual already_AddRefed<nsIBrowserChild> GetBrowserChild(void) override; \
  virtual nsCommandManager * GetCommandManager(void) override; \
  NS_IMETHOD GetUseTrackingProtection(bool *aUseTrackingProtection) override; \
  NS_IMETHOD SetUseTrackingProtection(bool aUseTrackingProtection) override; \
  NS_IMETHOD DispatchLocationChangeEvent(void) override; \
  NS_IMETHOD StartDelayedAutoplayMediaComponents(void) override; \
  virtual mozilla::UniquePtr<mozilla::dom::ClientSource> TakeInitialClientSource(void) override; \
  NS_IMETHOD SetColorMatrix(const nsTArray<float >& aMatrix) override; \
  NS_IMETHOD GetIsForceReloading(bool *aIsForceReloading) override; \
  NS_IMETHOD GetColorMatrix(nsTArray<float >& _retval) override; \
  using nsIDocShell::GetMessageManager; \
  NS_IMETHOD GetMessageManager(mozilla::dom::ContentFrameMessageManager **aMessageManager) override; \
  NS_IMETHOD GetHasTrackingContentBlocked(::mozilla::dom::Promise * * _retval) override; \
  virtual bool GetIsAttemptingToNavigate() override; \
  using nsIDocShell::GetIsNavigating; \
  NS_IMETHOD GetIsNavigating(bool *aIsNavigating) override; \
  NS_IMETHOD SynchronizeLayoutHistoryState(void) override; \
  NS_IMETHOD PersistLayoutHistoryState(void) override; 

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSIDOCSHELL \
  nsresult SetCancelContentJSEpoch(int32_t aEpoch); \
  nsresult LoadURI(nsDocShellLoadState* aLoadState, bool aSetNavigating); \
  MOZ_CAN_RUN_SCRIPT nsresult AddState(JS::Handle<JS::Value> aData, const nsAString& aTitle, const nsAString& aURL, bool aReplace, JSContext* cx); \
  nsresult PrepareForNewContentModel(void); \
  nsresult SetCurrentURIForSessionStore(nsIURI *aURI); \
  nsresult FirePageHideNotification(bool isUnload); \
  nsPresContext * GetPresContext(); \
  mozilla::PresShell * GetPresShell(); \
  mozilla::PresShell * GetEldestPresShell(); \
  using nsIDocShell::GetDocViewer; \
  nsresult GetDocViewer(nsIDocumentViewer **aDocViewer); \
  using nsIDocShell::GetOuterWindowID; \
  nsresult GetOuterWindowID(uint64_t *aOuterWindowID); \
  nsresult GetChromeEventHandler(mozilla::dom::EventTarget **aChromeEventHandler); \
  nsresult SetChromeEventHandler(mozilla::dom::EventTarget *aChromeEventHandler); \
  nsresult GetCustomUserAgent(nsAString& aCustomUserAgent); \
  nsresult SetCustomUserAgent(const nsAString& aCustomUserAgent); \
  nsresult GetCssErrorReportingEnabled(bool *aCssErrorReportingEnabled); \
  nsresult SetCssErrorReportingEnabled(bool aCssErrorReportingEnabled); \
  nsresult GetAllowMetaRedirects(bool *aAllowMetaRedirects); \
  nsresult SetAllowMetaRedirects(bool aAllowMetaRedirects); \
  nsresult GetAllowSubframes(bool *aAllowSubframes); \
  nsresult SetAllowSubframes(bool aAllowSubframes); \
  nsresult GetAllowImages(bool *aAllowImages); \
  nsresult SetAllowImages(bool aAllowImages); \
  using nsIDocShell::GetAllowMedia; \
  nsresult GetAllowMedia(bool *aAllowMedia); \
  nsresult SetAllowMedia(bool aAllowMedia); \
  nsresult GetAllowDNSPrefetch(bool *aAllowDNSPrefetch); \
  nsresult SetAllowDNSPrefetch(bool aAllowDNSPrefetch); \
  nsresult GetAllowWindowControl(bool *aAllowWindowControl); \
  nsresult SetAllowWindowControl(bool aAllowWindowControl); \
  using nsIDocShell::GetAllowContentRetargeting; \
  nsresult GetAllowContentRetargeting(bool *aAllowContentRetargeting); \
  nsresult SetAllowContentRetargeting(bool aAllowContentRetargeting); \
  using nsIDocShell::GetAllowContentRetargetingOnChildren; \
  nsresult GetAllowContentRetargetingOnChildren(bool *aAllowContentRetargetingOnChildren); \
  nsresult SetAllowContentRetargetingOnChildren(bool aAllowContentRetargetingOnChildren); \
  nsresult GetAllDocShellsInSubtree(int32_t aItemType, nsIDocShell::DocShellEnumeratorDirection aDirection, nsTArray<RefPtr<nsIDocShell>>& _retval); \
  using nsIDocShell::GetAppType; \
  nsresult GetAppType(nsIDocShell::AppType *aAppType); \
  nsresult SetAppType(nsIDocShell::AppType aAppType); \
  nsresult GetAllowAuth(bool *aAllowAuth); \
  nsresult SetAllowAuth(bool aAllowAuth); \
  nsresult GetZoom(float *aZoom); \
  nsresult SetZoom(float aZoom); \
  using nsIDocShell::GetBusyFlags; \
  nsresult GetBusyFlags(nsIDocShell::BusyFlags *aBusyFlags); \
  using nsIDocShell::GetLoadType; \
  nsresult GetLoadType(uint32_t *aLoadType); \
  nsresult SetLoadType(uint32_t aLoadType); \
  nsresult GetDefaultLoadFlags(nsLoadFlags *aDefaultLoadFlags); \
  nsresult SetDefaultLoadFlags(nsLoadFlags aDefaultLoadFlags); \
  nsresult IsBeingDestroyed(bool *_retval); \
  nsresult GetIsExecutingOnLoadHandler(bool *aIsExecutingOnLoadHandler); \
  nsresult GetLayoutHistoryState(nsILayoutHistoryState **aLayoutHistoryState); \
  nsresult SetLayoutHistoryState(nsILayoutHistoryState *aLayoutHistoryState); \
  nsresult GetLoadURIDelegate(nsILoadURIDelegate **aLoadURIDelegate); \
  nsresult SuspendRefreshURIs(void); \
  nsresult ResumeRefreshURIs(void); \
  nsresult BeginRestore(nsIDocumentViewer *viewer, bool top); \
  nsresult FinishRestore(void); \
  nsresult ClearCachedUserAgent(void); \
  nsresult ClearCachedPlatform(void); \
  nsresult GetRestoringDocument(bool *aRestoringDocument); \
  nsresult GetUseErrorPages(bool *aUseErrorPages); \
  nsresult SetUseErrorPages(bool aUseErrorPages); \
  nsresult DisplayLoadError(nsresult aError, nsIURI *aURI, const char16_t * aURL, nsIChannel *aFailedChannel, bool *_retval); \
  nsresult GetFailedChannel(nsIChannel **aFailedChannel); \
  nsresult GetPreviousEntryIndex(int32_t *aPreviousEntryIndex); \
  nsresult GetLoadedEntryIndex(int32_t *aLoadedEntryIndex); \
  nsresult HistoryPurged(int32_t numEntries); \
  nsresult GetCurrentDocumentChannel(nsIChannel **aCurrentDocumentChannel); \
  using nsIDocShell::GetIsInUnload; \
  nsresult GetIsInUnload(bool *aIsInUnload); \
  nsresult_(void) DetachEditorFromWindow(void); \
  nsresult ExitPrintPreview(void); \
  nsresult GetHistoryID(nsID & aHistoryID); \
  nsresult_(const nsID &) HistoryID(void); \
  nsresult CreateAboutBlankDocumentViewer(nsIPrincipal *aPrincipal, nsIPrincipal *aPartitionedPrincipal, nsIContentSecurityPolicy *aCSP); \
  nsresult GetCharset(nsACString& aCharset); \
  nsresult ForceEncodingDetection(void); \
  void SetParentCharset(const mozilla::Encoding* & parentCharset, int32_t parentCharsetSource, nsIPrincipal *parentCharsetPrincipal); \
  void GetParentCharset(const mozilla::Encoding* & parentCharset, int32_t *parentCharsetSource, nsIPrincipal **parentCharsetPrincipal); \
  nsresult Now(DOMHighResTimeStamp *_retval); \
  nsresult AddWeakPrivacyTransitionObserver(nsIPrivacyTransitionObserver *obs); \
  nsresult AddWeakReflowObserver(nsIReflowObserver *obs); \
  nsresult RemoveWeakReflowObserver(nsIReflowObserver *obs); \
  nsresult NotifyReflowObservers(bool interruptible, DOMHighResTimeStamp start, DOMHighResTimeStamp end); \
  nsresult AddWeakScrollObserver(nsIScrollObserver *obs); \
  nsresult RemoveWeakScrollObserver(nsIScrollObserver *obs); \
  nsresult NotifyScrollObservers(void); \
  using nsIDocShell::GetIsTopLevelContentDocShell; \
  nsresult GetIsTopLevelContentDocShell(bool *aIsTopLevelContentDocShell); \
  nsresult GetAsyncPanZoomEnabled(bool *aAsyncPanZoomEnabled); \
  using nsIDocShell::GetMayEnableCharacterEncodingMenu; \
  nsresult GetMayEnableCharacterEncodingMenu(bool *aMayEnableCharacterEncodingMenu); \
  nsresult GetEditor(nsIEditor **aEditor); \
  nsresult SetEditor(nsIEditor *aEditor); \
  nsresult GetEditable(bool *aEditable); \
  nsresult GetHasEditingSession(bool *aHasEditingSession); \
  nsresult MakeEditable(bool inWaitForUriLoad); \
  nsresult GetCurrentSHEntry(nsISHEntry **aEntry, bool *_retval); \
  nsresult IsCommandEnabled(const char * command, bool *_retval); \
  MOZ_CAN_RUN_SCRIPT nsresult DoCommand(const char * command); \
  MOZ_CAN_RUN_SCRIPT nsresult DoCommandWithParams(const char * command, nsICommandParams *aParams); \
  nsresult_(bool) IsInvisible(void); \
  nsresult_(void) SetInvisible(bool aIsInvisibleDocshell); \
  nsIScriptGlobalObject * GetScriptGlobalObject(void); \
  mozilla::dom::Document * GetExtantDocument(void); \
  using nsIDocShell::GetHasLoadedNonBlankURI; \
  nsresult GetHasLoadedNonBlankURI(bool *aHasLoadedNonBlankURI); \
  nsresult GetWindowDraggingAllowed(bool *aWindowDraggingAllowed); \
  nsresult SetWindowDraggingAllowed(bool aWindowDraggingAllowed); \
  nsresult GetCurrentScrollRestorationIsManual(bool *aCurrentScrollRestorationIsManual); \
  nsresult SetCurrentScrollRestorationIsManual(bool aCurrentScrollRestorationIsManual); \
  nsresult GetOriginAttributes(JSContext* cx, JS::MutableHandle<JS::Value> _retval); \
  nsresult SetOriginAttributes(JS::Handle<JS::Value> aAttrs, JSContext* cx); \
  nsresult GetEditingSession(nsIEditingSession **aEditingSession); \
  nsresult GetScriptableBrowserChild(nsIBrowserChild **aBrowserChild); \
  already_AddRefed<nsIBrowserChild> GetBrowserChild(void); \
  nsCommandManager * GetCommandManager(void); \
  nsresult GetUseTrackingProtection(bool *aUseTrackingProtection); \
  nsresult SetUseTrackingProtection(bool aUseTrackingProtection); \
  nsresult DispatchLocationChangeEvent(void); \
  nsresult StartDelayedAutoplayMediaComponents(void); \
  mozilla::UniquePtr<mozilla::dom::ClientSource> TakeInitialClientSource(void); \
  nsresult SetColorMatrix(const nsTArray<float >& aMatrix); \
  nsresult GetIsForceReloading(bool *aIsForceReloading); \
  nsresult GetColorMatrix(nsTArray<float >& _retval); \
  using nsIDocShell::GetMessageManager; \
  nsresult GetMessageManager(mozilla::dom::ContentFrameMessageManager **aMessageManager); \
  nsresult GetHasTrackingContentBlocked(::mozilla::dom::Promise * * _retval); \
  bool GetIsAttemptingToNavigate(); \
  using nsIDocShell::GetIsNavigating; \
  nsresult GetIsNavigating(bool *aIsNavigating); \
  nsresult SynchronizeLayoutHistoryState(void); \
  nsresult PersistLayoutHistoryState(void); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIDOCSHELL(_to) \
  NS_IMETHOD SetCancelContentJSEpoch(int32_t aEpoch) override { return _to SetCancelContentJSEpoch(aEpoch); } \
  NS_IMETHOD LoadURI(nsDocShellLoadState* aLoadState, bool aSetNavigating) override { return _to LoadURI(aLoadState, aSetNavigating); } \
  MOZ_CAN_RUN_SCRIPT NS_IMETHOD AddState(JS::Handle<JS::Value> aData, const nsAString& aTitle, const nsAString& aURL, bool aReplace, JSContext* cx) override { return _to AddState(aData, aTitle, aURL, aReplace, cx); } \
  NS_IMETHOD PrepareForNewContentModel(void) override { return _to PrepareForNewContentModel(); } \
  NS_IMETHOD SetCurrentURIForSessionStore(nsIURI *aURI) override { return _to SetCurrentURIForSessionStore(aURI); } \
  NS_IMETHOD FirePageHideNotification(bool isUnload) override { return _to FirePageHideNotification(isUnload); } \
  virtual nsPresContext * GetPresContext() override { return _to GetPresContext(); } \
  virtual mozilla::PresShell * GetPresShell() override { return _to GetPresShell(); } \
  virtual mozilla::PresShell * GetEldestPresShell() override { return _to GetEldestPresShell(); } \
  using nsIDocShell::GetDocViewer; \
  NS_IMETHOD GetDocViewer(nsIDocumentViewer **aDocViewer) override { return _to GetDocViewer(aDocViewer); } \
  using nsIDocShell::GetOuterWindowID; \
  NS_IMETHOD GetOuterWindowID(uint64_t *aOuterWindowID) override { return _to GetOuterWindowID(aOuterWindowID); } \
  NS_IMETHOD GetChromeEventHandler(mozilla::dom::EventTarget **aChromeEventHandler) override { return _to GetChromeEventHandler(aChromeEventHandler); } \
  NS_IMETHOD SetChromeEventHandler(mozilla::dom::EventTarget *aChromeEventHandler) override { return _to SetChromeEventHandler(aChromeEventHandler); } \
  NS_IMETHOD GetCustomUserAgent(nsAString& aCustomUserAgent) override { return _to GetCustomUserAgent(aCustomUserAgent); } \
  NS_IMETHOD SetCustomUserAgent(const nsAString& aCustomUserAgent) override { return _to SetCustomUserAgent(aCustomUserAgent); } \
  NS_IMETHOD GetCssErrorReportingEnabled(bool *aCssErrorReportingEnabled) override { return _to GetCssErrorReportingEnabled(aCssErrorReportingEnabled); } \
  NS_IMETHOD SetCssErrorReportingEnabled(bool aCssErrorReportingEnabled) override { return _to SetCssErrorReportingEnabled(aCssErrorReportingEnabled); } \
  NS_IMETHOD GetAllowMetaRedirects(bool *aAllowMetaRedirects) override { return _to GetAllowMetaRedirects(aAllowMetaRedirects); } \
  NS_IMETHOD SetAllowMetaRedirects(bool aAllowMetaRedirects) override { return _to SetAllowMetaRedirects(aAllowMetaRedirects); } \
  NS_IMETHOD GetAllowSubframes(bool *aAllowSubframes) override { return _to GetAllowSubframes(aAllowSubframes); } \
  NS_IMETHOD SetAllowSubframes(bool aAllowSubframes) override { return _to SetAllowSubframes(aAllowSubframes); } \
  NS_IMETHOD GetAllowImages(bool *aAllowImages) override { return _to GetAllowImages(aAllowImages); } \
  NS_IMETHOD SetAllowImages(bool aAllowImages) override { return _to SetAllowImages(aAllowImages); } \
  using nsIDocShell::GetAllowMedia; \
  NS_IMETHOD GetAllowMedia(bool *aAllowMedia) override { return _to GetAllowMedia(aAllowMedia); } \
  NS_IMETHOD SetAllowMedia(bool aAllowMedia) override { return _to SetAllowMedia(aAllowMedia); } \
  NS_IMETHOD GetAllowDNSPrefetch(bool *aAllowDNSPrefetch) override { return _to GetAllowDNSPrefetch(aAllowDNSPrefetch); } \
  NS_IMETHOD SetAllowDNSPrefetch(bool aAllowDNSPrefetch) override { return _to SetAllowDNSPrefetch(aAllowDNSPrefetch); } \
  NS_IMETHOD GetAllowWindowControl(bool *aAllowWindowControl) override { return _to GetAllowWindowControl(aAllowWindowControl); } \
  NS_IMETHOD SetAllowWindowControl(bool aAllowWindowControl) override { return _to SetAllowWindowControl(aAllowWindowControl); } \
  using nsIDocShell::GetAllowContentRetargeting; \
  NS_IMETHOD GetAllowContentRetargeting(bool *aAllowContentRetargeting) override { return _to GetAllowContentRetargeting(aAllowContentRetargeting); } \
  NS_IMETHOD SetAllowContentRetargeting(bool aAllowContentRetargeting) override { return _to SetAllowContentRetargeting(aAllowContentRetargeting); } \
  using nsIDocShell::GetAllowContentRetargetingOnChildren; \
  NS_IMETHOD GetAllowContentRetargetingOnChildren(bool *aAllowContentRetargetingOnChildren) override { return _to GetAllowContentRetargetingOnChildren(aAllowContentRetargetingOnChildren); } \
  NS_IMETHOD SetAllowContentRetargetingOnChildren(bool aAllowContentRetargetingOnChildren) override { return _to SetAllowContentRetargetingOnChildren(aAllowContentRetargetingOnChildren); } \
  NS_IMETHOD GetAllDocShellsInSubtree(int32_t aItemType, nsIDocShell::DocShellEnumeratorDirection aDirection, nsTArray<RefPtr<nsIDocShell>>& _retval) override { return _to GetAllDocShellsInSubtree(aItemType, aDirection, _retval); } \
  using nsIDocShell::GetAppType; \
  NS_IMETHOD GetAppType(nsIDocShell::AppType *aAppType) override { return _to GetAppType(aAppType); } \
  NS_IMETHOD SetAppType(nsIDocShell::AppType aAppType) override { return _to SetAppType(aAppType); } \
  NS_IMETHOD GetAllowAuth(bool *aAllowAuth) override { return _to GetAllowAuth(aAllowAuth); } \
  NS_IMETHOD SetAllowAuth(bool aAllowAuth) override { return _to SetAllowAuth(aAllowAuth); } \
  NS_IMETHOD GetZoom(float *aZoom) override { return _to GetZoom(aZoom); } \
  NS_IMETHOD SetZoom(float aZoom) override { return _to SetZoom(aZoom); } \
  using nsIDocShell::GetBusyFlags; \
  NS_IMETHOD GetBusyFlags(nsIDocShell::BusyFlags *aBusyFlags) override { return _to GetBusyFlags(aBusyFlags); } \
  using nsIDocShell::GetLoadType; \
  NS_IMETHOD GetLoadType(uint32_t *aLoadType) override { return _to GetLoadType(aLoadType); } \
  NS_IMETHOD SetLoadType(uint32_t aLoadType) override { return _to SetLoadType(aLoadType); } \
  NS_IMETHOD GetDefaultLoadFlags(nsLoadFlags *aDefaultLoadFlags) override { return _to GetDefaultLoadFlags(aDefaultLoadFlags); } \
  NS_IMETHOD SetDefaultLoadFlags(nsLoadFlags aDefaultLoadFlags) override { return _to SetDefaultLoadFlags(aDefaultLoadFlags); } \
  NS_IMETHOD IsBeingDestroyed(bool *_retval) override { return _to IsBeingDestroyed(_retval); } \
  NS_IMETHOD GetIsExecutingOnLoadHandler(bool *aIsExecutingOnLoadHandler) override { return _to GetIsExecutingOnLoadHandler(aIsExecutingOnLoadHandler); } \
  NS_IMETHOD GetLayoutHistoryState(nsILayoutHistoryState **aLayoutHistoryState) override { return _to GetLayoutHistoryState(aLayoutHistoryState); } \
  NS_IMETHOD SetLayoutHistoryState(nsILayoutHistoryState *aLayoutHistoryState) override { return _to SetLayoutHistoryState(aLayoutHistoryState); } \
  NS_IMETHOD GetLoadURIDelegate(nsILoadURIDelegate **aLoadURIDelegate) override { return _to GetLoadURIDelegate(aLoadURIDelegate); } \
  NS_IMETHOD SuspendRefreshURIs(void) override { return _to SuspendRefreshURIs(); } \
  NS_IMETHOD ResumeRefreshURIs(void) override { return _to ResumeRefreshURIs(); } \
  NS_IMETHOD BeginRestore(nsIDocumentViewer *viewer, bool top) override { return _to BeginRestore(viewer, top); } \
  NS_IMETHOD FinishRestore(void) override { return _to FinishRestore(); } \
  NS_IMETHOD ClearCachedUserAgent(void) override { return _to ClearCachedUserAgent(); } \
  NS_IMETHOD ClearCachedPlatform(void) override { return _to ClearCachedPlatform(); } \
  NS_IMETHOD GetRestoringDocument(bool *aRestoringDocument) override { return _to GetRestoringDocument(aRestoringDocument); } \
  NS_IMETHOD GetUseErrorPages(bool *aUseErrorPages) override { return _to GetUseErrorPages(aUseErrorPages); } \
  NS_IMETHOD SetUseErrorPages(bool aUseErrorPages) override { return _to SetUseErrorPages(aUseErrorPages); } \
  NS_IMETHOD DisplayLoadError(nsresult aError, nsIURI *aURI, const char16_t * aURL, nsIChannel *aFailedChannel, bool *_retval) override { return _to DisplayLoadError(aError, aURI, aURL, aFailedChannel, _retval); } \
  NS_IMETHOD GetFailedChannel(nsIChannel **aFailedChannel) override { return _to GetFailedChannel(aFailedChannel); } \
  NS_IMETHOD GetPreviousEntryIndex(int32_t *aPreviousEntryIndex) override { return _to GetPreviousEntryIndex(aPreviousEntryIndex); } \
  NS_IMETHOD GetLoadedEntryIndex(int32_t *aLoadedEntryIndex) override { return _to GetLoadedEntryIndex(aLoadedEntryIndex); } \
  NS_IMETHOD HistoryPurged(int32_t numEntries) override { return _to HistoryPurged(numEntries); } \
  NS_IMETHOD GetCurrentDocumentChannel(nsIChannel **aCurrentDocumentChannel) override { return _to GetCurrentDocumentChannel(aCurrentDocumentChannel); } \
  using nsIDocShell::GetIsInUnload; \
  NS_IMETHOD GetIsInUnload(bool *aIsInUnload) override { return _to GetIsInUnload(aIsInUnload); } \
  NS_IMETHOD_(void) DetachEditorFromWindow(void) override { return _to DetachEditorFromWindow(); } \
  NS_IMETHOD ExitPrintPreview(void) override { return _to ExitPrintPreview(); } \
  NS_IMETHOD GetHistoryID(nsID & aHistoryID) override { return _to GetHistoryID(aHistoryID); } \
  NS_IMETHOD_(const nsID &) HistoryID(void) override { return _to HistoryID(); } \
  NS_IMETHOD CreateAboutBlankDocumentViewer(nsIPrincipal *aPrincipal, nsIPrincipal *aPartitionedPrincipal, nsIContentSecurityPolicy *aCSP) override { return _to CreateAboutBlankDocumentViewer(aPrincipal, aPartitionedPrincipal, aCSP); } \
  NS_IMETHOD GetCharset(nsACString& aCharset) override { return _to GetCharset(aCharset); } \
  NS_IMETHOD ForceEncodingDetection(void) override { return _to ForceEncodingDetection(); } \
  virtual void SetParentCharset(const mozilla::Encoding* & parentCharset, int32_t parentCharsetSource, nsIPrincipal *parentCharsetPrincipal) override { return _to SetParentCharset(parentCharset, parentCharsetSource, parentCharsetPrincipal); } \
  virtual void GetParentCharset(const mozilla::Encoding* & parentCharset, int32_t *parentCharsetSource, nsIPrincipal **parentCharsetPrincipal) override { return _to GetParentCharset(parentCharset, parentCharsetSource, parentCharsetPrincipal); } \
  NS_IMETHOD Now(DOMHighResTimeStamp *_retval) override { return _to Now(_retval); } \
  NS_IMETHOD AddWeakPrivacyTransitionObserver(nsIPrivacyTransitionObserver *obs) override { return _to AddWeakPrivacyTransitionObserver(obs); } \
  NS_IMETHOD AddWeakReflowObserver(nsIReflowObserver *obs) override { return _to AddWeakReflowObserver(obs); } \
  NS_IMETHOD RemoveWeakReflowObserver(nsIReflowObserver *obs) override { return _to RemoveWeakReflowObserver(obs); } \
  NS_IMETHOD NotifyReflowObservers(bool interruptible, DOMHighResTimeStamp start, DOMHighResTimeStamp end) override { return _to NotifyReflowObservers(interruptible, start, end); } \
  NS_IMETHOD AddWeakScrollObserver(nsIScrollObserver *obs) override { return _to AddWeakScrollObserver(obs); } \
  NS_IMETHOD RemoveWeakScrollObserver(nsIScrollObserver *obs) override { return _to RemoveWeakScrollObserver(obs); } \
  NS_IMETHOD NotifyScrollObservers(void) override { return _to NotifyScrollObservers(); } \
  using nsIDocShell::GetIsTopLevelContentDocShell; \
  NS_IMETHOD GetIsTopLevelContentDocShell(bool *aIsTopLevelContentDocShell) override { return _to GetIsTopLevelContentDocShell(aIsTopLevelContentDocShell); } \
  NS_IMETHOD GetAsyncPanZoomEnabled(bool *aAsyncPanZoomEnabled) override { return _to GetAsyncPanZoomEnabled(aAsyncPanZoomEnabled); } \
  using nsIDocShell::GetMayEnableCharacterEncodingMenu; \
  NS_IMETHOD GetMayEnableCharacterEncodingMenu(bool *aMayEnableCharacterEncodingMenu) override { return _to GetMayEnableCharacterEncodingMenu(aMayEnableCharacterEncodingMenu); } \
  NS_IMETHOD GetEditor(nsIEditor **aEditor) override { return _to GetEditor(aEditor); } \
  NS_IMETHOD SetEditor(nsIEditor *aEditor) override { return _to SetEditor(aEditor); } \
  NS_IMETHOD GetEditable(bool *aEditable) override { return _to GetEditable(aEditable); } \
  NS_IMETHOD GetHasEditingSession(bool *aHasEditingSession) override { return _to GetHasEditingSession(aHasEditingSession); } \
  NS_IMETHOD MakeEditable(bool inWaitForUriLoad) override { return _to MakeEditable(inWaitForUriLoad); } \
  NS_IMETHOD GetCurrentSHEntry(nsISHEntry **aEntry, bool *_retval) override { return _to GetCurrentSHEntry(aEntry, _retval); } \
  NS_IMETHOD IsCommandEnabled(const char * command, bool *_retval) override { return _to IsCommandEnabled(command, _retval); } \
  MOZ_CAN_RUN_SCRIPT NS_IMETHOD DoCommand(const char * command) override { return _to DoCommand(command); } \
  MOZ_CAN_RUN_SCRIPT NS_IMETHOD DoCommandWithParams(const char * command, nsICommandParams *aParams) override { return _to DoCommandWithParams(command, aParams); } \
  NS_IMETHOD_(bool) IsInvisible(void) override { return _to IsInvisible(); } \
  NS_IMETHOD_(void) SetInvisible(bool aIsInvisibleDocshell) override { return _to SetInvisible(aIsInvisibleDocshell); } \
  virtual nsIScriptGlobalObject * GetScriptGlobalObject(void) override { return _to GetScriptGlobalObject(); } \
  virtual mozilla::dom::Document * GetExtantDocument(void) override { return _to GetExtantDocument(); } \
  using nsIDocShell::GetHasLoadedNonBlankURI; \
  NS_IMETHOD GetHasLoadedNonBlankURI(bool *aHasLoadedNonBlankURI) override { return _to GetHasLoadedNonBlankURI(aHasLoadedNonBlankURI); } \
  NS_IMETHOD GetWindowDraggingAllowed(bool *aWindowDraggingAllowed) override { return _to GetWindowDraggingAllowed(aWindowDraggingAllowed); } \
  NS_IMETHOD SetWindowDraggingAllowed(bool aWindowDraggingAllowed) override { return _to SetWindowDraggingAllowed(aWindowDraggingAllowed); } \
  NS_IMETHOD GetCurrentScrollRestorationIsManual(bool *aCurrentScrollRestorationIsManual) override { return _to GetCurrentScrollRestorationIsManual(aCurrentScrollRestorationIsManual); } \
  NS_IMETHOD SetCurrentScrollRestorationIsManual(bool aCurrentScrollRestorationIsManual) override { return _to SetCurrentScrollRestorationIsManual(aCurrentScrollRestorationIsManual); } \
  NS_IMETHOD GetOriginAttributes(JSContext* cx, JS::MutableHandle<JS::Value> _retval) override { return _to GetOriginAttributes(cx, _retval); } \
  NS_IMETHOD SetOriginAttributes(JS::Handle<JS::Value> aAttrs, JSContext* cx) override { return _to SetOriginAttributes(aAttrs, cx); } \
  NS_IMETHOD GetEditingSession(nsIEditingSession **aEditingSession) override { return _to GetEditingSession(aEditingSession); } \
  NS_IMETHOD GetScriptableBrowserChild(nsIBrowserChild **aBrowserChild) override { return _to GetScriptableBrowserChild(aBrowserChild); } \
  virtual already_AddRefed<nsIBrowserChild> GetBrowserChild(void) override { return _to GetBrowserChild(); } \
  virtual nsCommandManager * GetCommandManager(void) override { return _to GetCommandManager(); } \
  NS_IMETHOD GetUseTrackingProtection(bool *aUseTrackingProtection) override { return _to GetUseTrackingProtection(aUseTrackingProtection); } \
  NS_IMETHOD SetUseTrackingProtection(bool aUseTrackingProtection) override { return _to SetUseTrackingProtection(aUseTrackingProtection); } \
  NS_IMETHOD DispatchLocationChangeEvent(void) override { return _to DispatchLocationChangeEvent(); } \
  NS_IMETHOD StartDelayedAutoplayMediaComponents(void) override { return _to StartDelayedAutoplayMediaComponents(); } \
  virtual mozilla::UniquePtr<mozilla::dom::ClientSource> TakeInitialClientSource(void) override { return _to TakeInitialClientSource(); } \
  NS_IMETHOD SetColorMatrix(const nsTArray<float >& aMatrix) override { return _to SetColorMatrix(aMatrix); } \
  NS_IMETHOD GetIsForceReloading(bool *aIsForceReloading) override { return _to GetIsForceReloading(aIsForceReloading); } \
  NS_IMETHOD GetColorMatrix(nsTArray<float >& _retval) override { return _to GetColorMatrix(_retval); } \
  using nsIDocShell::GetMessageManager; \
  NS_IMETHOD GetMessageManager(mozilla::dom::ContentFrameMessageManager **aMessageManager) override { return _to GetMessageManager(aMessageManager); } \
  NS_IMETHOD GetHasTrackingContentBlocked(::mozilla::dom::Promise * * _retval) override { return _to GetHasTrackingContentBlocked(_retval); } \
  virtual bool GetIsAttemptingToNavigate() override { return _to GetIsAttemptingToNavigate(); } \
  using nsIDocShell::GetIsNavigating; \
  NS_IMETHOD GetIsNavigating(bool *aIsNavigating) override { return _to GetIsNavigating(aIsNavigating); } \
  NS_IMETHOD SynchronizeLayoutHistoryState(void) override { return _to SynchronizeLayoutHistoryState(); } \
  NS_IMETHOD PersistLayoutHistoryState(void) override { return _to PersistLayoutHistoryState(); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIDOCSHELL(_to) \
  NS_IMETHOD SetCancelContentJSEpoch(int32_t aEpoch) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetCancelContentJSEpoch(aEpoch); } \
  NS_IMETHOD LoadURI(nsDocShellLoadState* aLoadState, bool aSetNavigating) override { return !_to ? NS_ERROR_NULL_POINTER : _to->LoadURI(aLoadState, aSetNavigating); } \
  MOZ_CAN_RUN_SCRIPT NS_IMETHOD AddState(JS::Handle<JS::Value> aData, const nsAString& aTitle, const nsAString& aURL, bool aReplace, JSContext* cx) override { return !_to ? NS_ERROR_NULL_POINTER : _to->AddState(aData, aTitle, aURL, aReplace, cx); } \
  NS_IMETHOD PrepareForNewContentModel(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->PrepareForNewContentModel(); } \
  NS_IMETHOD SetCurrentURIForSessionStore(nsIURI *aURI) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetCurrentURIForSessionStore(aURI); } \
  NS_IMETHOD FirePageHideNotification(bool isUnload) override { return !_to ? NS_ERROR_NULL_POINTER : _to->FirePageHideNotification(isUnload); } \
  virtual nsPresContext * GetPresContext() override; \
  virtual mozilla::PresShell * GetPresShell() override; \
  virtual mozilla::PresShell * GetEldestPresShell() override; \
  NS_IMETHOD GetDocViewer(nsIDocumentViewer **aDocViewer) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDocViewer(aDocViewer); } \
  NS_IMETHOD GetOuterWindowID(uint64_t *aOuterWindowID) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetOuterWindowID(aOuterWindowID); } \
  NS_IMETHOD GetChromeEventHandler(mozilla::dom::EventTarget **aChromeEventHandler) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetChromeEventHandler(aChromeEventHandler); } \
  NS_IMETHOD SetChromeEventHandler(mozilla::dom::EventTarget *aChromeEventHandler) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetChromeEventHandler(aChromeEventHandler); } \
  NS_IMETHOD GetCustomUserAgent(nsAString& aCustomUserAgent) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCustomUserAgent(aCustomUserAgent); } \
  NS_IMETHOD SetCustomUserAgent(const nsAString& aCustomUserAgent) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetCustomUserAgent(aCustomUserAgent); } \
  NS_IMETHOD GetCssErrorReportingEnabled(bool *aCssErrorReportingEnabled) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCssErrorReportingEnabled(aCssErrorReportingEnabled); } \
  NS_IMETHOD SetCssErrorReportingEnabled(bool aCssErrorReportingEnabled) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetCssErrorReportingEnabled(aCssErrorReportingEnabled); } \
  NS_IMETHOD GetAllowMetaRedirects(bool *aAllowMetaRedirects) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAllowMetaRedirects(aAllowMetaRedirects); } \
  NS_IMETHOD SetAllowMetaRedirects(bool aAllowMetaRedirects) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetAllowMetaRedirects(aAllowMetaRedirects); } \
  NS_IMETHOD GetAllowSubframes(bool *aAllowSubframes) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAllowSubframes(aAllowSubframes); } \
  NS_IMETHOD SetAllowSubframes(bool aAllowSubframes) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetAllowSubframes(aAllowSubframes); } \
  NS_IMETHOD GetAllowImages(bool *aAllowImages) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAllowImages(aAllowImages); } \
  NS_IMETHOD SetAllowImages(bool aAllowImages) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetAllowImages(aAllowImages); } \
  NS_IMETHOD GetAllowMedia(bool *aAllowMedia) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAllowMedia(aAllowMedia); } \
  NS_IMETHOD SetAllowMedia(bool aAllowMedia) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetAllowMedia(aAllowMedia); } \
  NS_IMETHOD GetAllowDNSPrefetch(bool *aAllowDNSPrefetch) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAllowDNSPrefetch(aAllowDNSPrefetch); } \
  NS_IMETHOD SetAllowDNSPrefetch(bool aAllowDNSPrefetch) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetAllowDNSPrefetch(aAllowDNSPrefetch); } \
  NS_IMETHOD GetAllowWindowControl(bool *aAllowWindowControl) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAllowWindowControl(aAllowWindowControl); } \
  NS_IMETHOD SetAllowWindowControl(bool aAllowWindowControl) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetAllowWindowControl(aAllowWindowControl); } \
  NS_IMETHOD GetAllowContentRetargeting(bool *aAllowContentRetargeting) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAllowContentRetargeting(aAllowContentRetargeting); } \
  NS_IMETHOD SetAllowContentRetargeting(bool aAllowContentRetargeting) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetAllowContentRetargeting(aAllowContentRetargeting); } \
  NS_IMETHOD GetAllowContentRetargetingOnChildren(bool *aAllowContentRetargetingOnChildren) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAllowContentRetargetingOnChildren(aAllowContentRetargetingOnChildren); } \
  NS_IMETHOD SetAllowContentRetargetingOnChildren(bool aAllowContentRetargetingOnChildren) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetAllowContentRetargetingOnChildren(aAllowContentRetargetingOnChildren); } \
  NS_IMETHOD GetAllDocShellsInSubtree(int32_t aItemType, nsIDocShell::DocShellEnumeratorDirection aDirection, nsTArray<RefPtr<nsIDocShell>>& _retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAllDocShellsInSubtree(aItemType, aDirection, _retval); } \
  NS_IMETHOD GetAppType(nsIDocShell::AppType *aAppType) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAppType(aAppType); } \
  NS_IMETHOD SetAppType(nsIDocShell::AppType aAppType) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetAppType(aAppType); } \
  NS_IMETHOD GetAllowAuth(bool *aAllowAuth) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAllowAuth(aAllowAuth); } \
  NS_IMETHOD SetAllowAuth(bool aAllowAuth) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetAllowAuth(aAllowAuth); } \
  NS_IMETHOD GetZoom(float *aZoom) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetZoom(aZoom); } \
  NS_IMETHOD SetZoom(float aZoom) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetZoom(aZoom); } \
  NS_IMETHOD GetBusyFlags(nsIDocShell::BusyFlags *aBusyFlags) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetBusyFlags(aBusyFlags); } \
  NS_IMETHOD GetLoadType(uint32_t *aLoadType) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetLoadType(aLoadType); } \
  NS_IMETHOD SetLoadType(uint32_t aLoadType) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetLoadType(aLoadType); } \
  NS_IMETHOD GetDefaultLoadFlags(nsLoadFlags *aDefaultLoadFlags) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDefaultLoadFlags(aDefaultLoadFlags); } \
  NS_IMETHOD SetDefaultLoadFlags(nsLoadFlags aDefaultLoadFlags) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDefaultLoadFlags(aDefaultLoadFlags); } \
  NS_IMETHOD IsBeingDestroyed(bool *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->IsBeingDestroyed(_retval); } \
  NS_IMETHOD GetIsExecutingOnLoadHandler(bool *aIsExecutingOnLoadHandler) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIsExecutingOnLoadHandler(aIsExecutingOnLoadHandler); } \
  NS_IMETHOD GetLayoutHistoryState(nsILayoutHistoryState **aLayoutHistoryState) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetLayoutHistoryState(aLayoutHistoryState); } \
  NS_IMETHOD SetLayoutHistoryState(nsILayoutHistoryState *aLayoutHistoryState) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetLayoutHistoryState(aLayoutHistoryState); } \
  NS_IMETHOD GetLoadURIDelegate(nsILoadURIDelegate **aLoadURIDelegate) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetLoadURIDelegate(aLoadURIDelegate); } \
  NS_IMETHOD SuspendRefreshURIs(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SuspendRefreshURIs(); } \
  NS_IMETHOD ResumeRefreshURIs(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->ResumeRefreshURIs(); } \
  NS_IMETHOD BeginRestore(nsIDocumentViewer *viewer, bool top) override { return !_to ? NS_ERROR_NULL_POINTER : _to->BeginRestore(viewer, top); } \
  NS_IMETHOD FinishRestore(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->FinishRestore(); } \
  NS_IMETHOD ClearCachedUserAgent(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->ClearCachedUserAgent(); } \
  NS_IMETHOD ClearCachedPlatform(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->ClearCachedPlatform(); } \
  NS_IMETHOD GetRestoringDocument(bool *aRestoringDocument) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRestoringDocument(aRestoringDocument); } \
  NS_IMETHOD GetUseErrorPages(bool *aUseErrorPages) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetUseErrorPages(aUseErrorPages); } \
  NS_IMETHOD SetUseErrorPages(bool aUseErrorPages) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetUseErrorPages(aUseErrorPages); } \
  NS_IMETHOD DisplayLoadError(nsresult aError, nsIURI *aURI, const char16_t * aURL, nsIChannel *aFailedChannel, bool *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->DisplayLoadError(aError, aURI, aURL, aFailedChannel, _retval); } \
  NS_IMETHOD GetFailedChannel(nsIChannel **aFailedChannel) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFailedChannel(aFailedChannel); } \
  NS_IMETHOD GetPreviousEntryIndex(int32_t *aPreviousEntryIndex) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPreviousEntryIndex(aPreviousEntryIndex); } \
  NS_IMETHOD GetLoadedEntryIndex(int32_t *aLoadedEntryIndex) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetLoadedEntryIndex(aLoadedEntryIndex); } \
  NS_IMETHOD HistoryPurged(int32_t numEntries) override { return !_to ? NS_ERROR_NULL_POINTER : _to->HistoryPurged(numEntries); } \
  NS_IMETHOD GetCurrentDocumentChannel(nsIChannel **aCurrentDocumentChannel) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCurrentDocumentChannel(aCurrentDocumentChannel); } \
  NS_IMETHOD GetIsInUnload(bool *aIsInUnload) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIsInUnload(aIsInUnload); } \
  NS_IMETHOD_(void) DetachEditorFromWindow(void) override; \
  NS_IMETHOD ExitPrintPreview(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->ExitPrintPreview(); } \
  NS_IMETHOD GetHistoryID(nsID & aHistoryID) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetHistoryID(aHistoryID); } \
  NS_IMETHOD_(const nsID &) HistoryID(void) override; \
  NS_IMETHOD CreateAboutBlankDocumentViewer(nsIPrincipal *aPrincipal, nsIPrincipal *aPartitionedPrincipal, nsIContentSecurityPolicy *aCSP) override { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateAboutBlankDocumentViewer(aPrincipal, aPartitionedPrincipal, aCSP); } \
  NS_IMETHOD GetCharset(nsACString& aCharset) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCharset(aCharset); } \
  NS_IMETHOD ForceEncodingDetection(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->ForceEncodingDetection(); } \
  virtual void SetParentCharset(const mozilla::Encoding* & parentCharset, int32_t parentCharsetSource, nsIPrincipal *parentCharsetPrincipal) override; \
  virtual void GetParentCharset(const mozilla::Encoding* & parentCharset, int32_t *parentCharsetSource, nsIPrincipal **parentCharsetPrincipal) override; \
  NS_IMETHOD Now(DOMHighResTimeStamp *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->Now(_retval); } \
  NS_IMETHOD AddWeakPrivacyTransitionObserver(nsIPrivacyTransitionObserver *obs) override { return !_to ? NS_ERROR_NULL_POINTER : _to->AddWeakPrivacyTransitionObserver(obs); } \
  NS_IMETHOD AddWeakReflowObserver(nsIReflowObserver *obs) override { return !_to ? NS_ERROR_NULL_POINTER : _to->AddWeakReflowObserver(obs); } \
  NS_IMETHOD RemoveWeakReflowObserver(nsIReflowObserver *obs) override { return !_to ? NS_ERROR_NULL_POINTER : _to->RemoveWeakReflowObserver(obs); } \
  NS_IMETHOD NotifyReflowObservers(bool interruptible, DOMHighResTimeStamp start, DOMHighResTimeStamp end) override { return !_to ? NS_ERROR_NULL_POINTER : _to->NotifyReflowObservers(interruptible, start, end); } \
  NS_IMETHOD AddWeakScrollObserver(nsIScrollObserver *obs) override { return !_to ? NS_ERROR_NULL_POINTER : _to->AddWeakScrollObserver(obs); } \
  NS_IMETHOD RemoveWeakScrollObserver(nsIScrollObserver *obs) override { return !_to ? NS_ERROR_NULL_POINTER : _to->RemoveWeakScrollObserver(obs); } \
  NS_IMETHOD NotifyScrollObservers(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->NotifyScrollObservers(); } \
  NS_IMETHOD GetIsTopLevelContentDocShell(bool *aIsTopLevelContentDocShell) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIsTopLevelContentDocShell(aIsTopLevelContentDocShell); } \
  NS_IMETHOD GetAsyncPanZoomEnabled(bool *aAsyncPanZoomEnabled) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAsyncPanZoomEnabled(aAsyncPanZoomEnabled); } \
  NS_IMETHOD GetMayEnableCharacterEncodingMenu(bool *aMayEnableCharacterEncodingMenu) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetMayEnableCharacterEncodingMenu(aMayEnableCharacterEncodingMenu); } \
  NS_IMETHOD GetEditor(nsIEditor **aEditor) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetEditor(aEditor); } \
  NS_IMETHOD SetEditor(nsIEditor *aEditor) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetEditor(aEditor); } \
  NS_IMETHOD GetEditable(bool *aEditable) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetEditable(aEditable); } \
  NS_IMETHOD GetHasEditingSession(bool *aHasEditingSession) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetHasEditingSession(aHasEditingSession); } \
  NS_IMETHOD MakeEditable(bool inWaitForUriLoad) override { return !_to ? NS_ERROR_NULL_POINTER : _to->MakeEditable(inWaitForUriLoad); } \
  NS_IMETHOD GetCurrentSHEntry(nsISHEntry **aEntry, bool *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCurrentSHEntry(aEntry, _retval); } \
  NS_IMETHOD IsCommandEnabled(const char * command, bool *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->IsCommandEnabled(command, _retval); } \
  MOZ_CAN_RUN_SCRIPT NS_IMETHOD DoCommand(const char * command) override { return !_to ? NS_ERROR_NULL_POINTER : _to->DoCommand(command); } \
  MOZ_CAN_RUN_SCRIPT NS_IMETHOD DoCommandWithParams(const char * command, nsICommandParams *aParams) override { return !_to ? NS_ERROR_NULL_POINTER : _to->DoCommandWithParams(command, aParams); } \
  NS_IMETHOD_(bool) IsInvisible(void) override; \
  NS_IMETHOD_(void) SetInvisible(bool aIsInvisibleDocshell) override; \
  virtual nsIScriptGlobalObject * GetScriptGlobalObject(void) override; \
  virtual mozilla::dom::Document * GetExtantDocument(void) override; \
  NS_IMETHOD GetHasLoadedNonBlankURI(bool *aHasLoadedNonBlankURI) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetHasLoadedNonBlankURI(aHasLoadedNonBlankURI); } \
  NS_IMETHOD GetWindowDraggingAllowed(bool *aWindowDraggingAllowed) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetWindowDraggingAllowed(aWindowDraggingAllowed); } \
  NS_IMETHOD SetWindowDraggingAllowed(bool aWindowDraggingAllowed) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetWindowDraggingAllowed(aWindowDraggingAllowed); } \
  NS_IMETHOD GetCurrentScrollRestorationIsManual(bool *aCurrentScrollRestorationIsManual) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCurrentScrollRestorationIsManual(aCurrentScrollRestorationIsManual); } \
  NS_IMETHOD SetCurrentScrollRestorationIsManual(bool aCurrentScrollRestorationIsManual) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetCurrentScrollRestorationIsManual(aCurrentScrollRestorationIsManual); } \
  NS_IMETHOD GetOriginAttributes(JSContext* cx, JS::MutableHandle<JS::Value> _retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetOriginAttributes(cx, _retval); } \
  NS_IMETHOD SetOriginAttributes(JS::Handle<JS::Value> aAttrs, JSContext* cx) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetOriginAttributes(aAttrs, cx); } \
  NS_IMETHOD GetEditingSession(nsIEditingSession **aEditingSession) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetEditingSession(aEditingSession); } \
  NS_IMETHOD GetScriptableBrowserChild(nsIBrowserChild **aBrowserChild) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetScriptableBrowserChild(aBrowserChild); } \
  virtual already_AddRefed<nsIBrowserChild> GetBrowserChild(void) override; \
  virtual nsCommandManager * GetCommandManager(void) override; \
  NS_IMETHOD GetUseTrackingProtection(bool *aUseTrackingProtection) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetUseTrackingProtection(aUseTrackingProtection); } \
  NS_IMETHOD SetUseTrackingProtection(bool aUseTrackingProtection) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetUseTrackingProtection(aUseTrackingProtection); } \
  NS_IMETHOD DispatchLocationChangeEvent(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->DispatchLocationChangeEvent(); } \
  NS_IMETHOD StartDelayedAutoplayMediaComponents(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->StartDelayedAutoplayMediaComponents(); } \
  virtual mozilla::UniquePtr<mozilla::dom::ClientSource> TakeInitialClientSource(void) override; \
  NS_IMETHOD SetColorMatrix(const nsTArray<float >& aMatrix) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetColorMatrix(aMatrix); } \
  NS_IMETHOD GetIsForceReloading(bool *aIsForceReloading) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIsForceReloading(aIsForceReloading); } \
  NS_IMETHOD GetColorMatrix(nsTArray<float >& _retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetColorMatrix(_retval); } \
  NS_IMETHOD GetMessageManager(mozilla::dom::ContentFrameMessageManager **aMessageManager) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetMessageManager(aMessageManager); } \
  NS_IMETHOD GetHasTrackingContentBlocked(::mozilla::dom::Promise * * _retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetHasTrackingContentBlocked(_retval); } \
  virtual bool GetIsAttemptingToNavigate() override; \
  NS_IMETHOD GetIsNavigating(bool *aIsNavigating) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIsNavigating(aIsNavigating); } \
  NS_IMETHOD SynchronizeLayoutHistoryState(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SynchronizeLayoutHistoryState(); } \
  NS_IMETHOD PersistLayoutHistoryState(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->PersistLayoutHistoryState(); } 


#endif /* __gen_nsIDocShell_h__ */
